# Safa Modest House - E-commerce Website

A complete Bangladesh-style e-commerce website built with **pure PHP (PDO)**, **Bootstrap 5**, **jQuery**, and **AJAX**.

## Features

### Customer Features
- **Product Browsing**: Home page with hero, featured products, categories, best sellers
- **Product Search & Filter**: By category, price, rating, and keyword
- **Product Details**: Multiple images, description, reviews, related products
- **Shopping Cart**: AJAX-based add/update/remove, quantity controls
- **Wishlist**: Save favorite products (requires login)
- **Checkout**: Shipping form, promo code, bKash/Nagad payment
- **Order Tracking**: Track order status and history
- **User Dashboard**: Order history, profile management
- **Reviews**: Submit product reviews (admin approval required)

### Admin Features
- **Dashboard**: Order stats, today's sales, pending payments
- **Order Management**: View orders, change status, verify payments
- **Product Management**: CRUD with multiple image upload
- **Promo Codes**: Create/edit percentage or fixed discounts
- **User Management**: View users, block/unblock
- **Review Moderation**: Approve or reject customer reviews

### Technical Features
- **No Page Reloads**: All operations via AJAX
- **CSRF Protection**: Token-based security for all forms
- **PDO Prepared Statements**: SQL injection prevention
- **Password Hashing**: Secure password storage
- **Session Management**: Separate user/admin sessions with timeout
- **Responsive Design**: Mobile-first Bootstrap 5
- **Bangladesh Localization**: Taka (৳) currency, bKash/Nagad, Bangla messages

## Requirements

- PHP 7.4+ (with PDO MySQL extension)
- MySQL 5.7+ / MariaDB 10.3+
- Apache with mod_rewrite (XAMPP recommended)

## Installation

### 1. Clone/Download
Place the project in your web server directory:
```
C:\xampp\htdocs\safa-modest-house
```

### 2. Create Database
```sql
CREATE DATABASE safa_modest_house CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
```

### 3. Import Schema
Import the database schema:
```
mysql -u root -p safa_modest_house < sql/schema.sql
```
Or use phpMyAdmin to import `sql/schema.sql`.

### 4. Configure Database
Edit `app/config/config.php`:
```php
define('DB_HOST', 'localhost');
define('DB_NAME', 'safa_modest_house');
define('DB_USER', 'root');
define('DB_PASS', '');
```

### 5. Set Permissions
Ensure the `storage/uploads` directory is writable:
```bash
chmod -R 755 storage/uploads
```

### 6. Access the Site
- **Frontend**: http://localhost/safa-modest-house/public/
- **Admin Panel**: http://localhost/safa-modest-house/admin/

### Default Admin Login
- **Email**: admin@safamodest.com
- **Password**: Admin@123

## Folder Structure

```
safa-modest-house/
├── admin/                  # Admin panel
│   ├── ajax/              # Admin AJAX handlers
│   ├── assets/            # Admin CSS/JS
│   ├── auth/              # Admin login/logout
│   ├── includes/          # Admin layout parts
│   └── pages/             # Admin pages
├── app/                   # Application core
│   ├── config/            # Configuration files
│   ├── core/              # Core classes (CSRF, Response, Validator, Upload)
│   ├── middleware/        # Auth middleware
│   └── services/          # Business logic services
├── public/                # Public frontend
│   ├── ajax/              # Frontend AJAX handlers
│   ├── assets/            # CSS/JS/images
│   ├── includes/          # Layout parts (head, navbar, footer)
│   └── pages/             # Frontend pages
├── sql/                   # Database schema
└── storage/               # Uploads and logs
```

## Configuration

Key settings in `app/config/config.php`:

| Setting | Description |
|---------|-------------|
| `VAT_PERCENT` | VAT percentage (default: 15%) |
| `SHIPPING_DHAKA` | Dhaka shipping cost (৳60) |
| `SHIPPING_OUTSIDE_DHAKA` | Outside Dhaka (৳120) |
| `BKASH_MERCHANT_NUMBER` | bKash merchant number |
| `NAGAD_MERCHANT_NUMBER` | Nagad merchant number |
| `WHATSAPP_NUMBER` | WhatsApp contact number |
| `MAX_PRODUCT_IMAGES` | Max images per product (10) |

## Payment Flow

1. Customer places order with shipping details
2. Customer selects bKash or Nagad
3. Customer sends money to merchant number
4. Customer enters sender mobile and Transaction ID
5. Admin verifies payment in admin panel
6. Order status updated to Processing → Shipped → Delivered

## Security

- All database queries use PDO prepared statements
- CSRF tokens on all forms and AJAX requests
- Password hashing with `password_hash()`
- Input sanitization with `htmlspecialchars()`
- Session timeout (2 hours user, 30 minutes admin)
- Secure file upload validation (MIME type, extension, size)

## Customization

### Add New Category
Insert into `categories` table via phpMyAdmin or admin panel.

### Change Colors
Edit CSS variables in `public/assets/css/site.css`:
```css
:root {
    --bs-primary: #your-color;
}
```

### Change Currency Symbol
Edit `CURRENCY_SYMBOL` in `app/config/config.php`.

## License

This project is for educational/commercial use. Customize as needed.

## Support

For issues or customization requests, contact via WhatsApp.
