<?php
/**
 * ============================================================
 * ADMIN AJAX: Verify Payment
 * ============================================================
 * Verify or reject bKash/Nagad payment submission
 */

// Initialize
define('BASE_PATH', dirname(dirname(dirname(__DIR__))));
require_once BASE_PATH . '/app/config/config.php';

// Start session
if (session_status() === PHP_SESSION_NONE) {
    session_name(SESSION_NAME);
    session_start();
}

// Must be POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Invalid request']);
    exit;
}

// Must be admin
if (!isAdminLoggedIn()) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'অ্যাডমিন লগইন প্রয়োজন']);
    exit;
}

// Load service
require_once APP_PATH . '/services/order_service.php';

// Get data
$paymentId = (int)post('payment_id');
$action = sanitize(post('action')); // 'verify' or 'reject'
$note = sanitize(post('note'));

// Validate
if ($paymentId < 1) {
    Response::error('অবৈধ পেমেন্ট রেকর্ড');
}

if (!in_array($action, ['verify', 'reject'])) {
    Response::error('অবৈধ অ্যাকশন');
}

// Map action to status
$status = $action === 'verify' ? 'Verified' : 'Rejected';

// Verify/Reject payment
$result = OrderService::verifyPayment($paymentId, getAdminId(), $status, $note);

if ($result['success']) {
    Response::success($result['message'], [
        'payment_id' => $paymentId,
        'status' => $status
    ]);
} else {
    Response::error($result['message']);
}
