<?php
/**
 * ============================================================
 * ADMIN AJAX: Delete Promo Code
 * ============================================================
 */

// Initialize
define('BASE_PATH', dirname(dirname(dirname(__DIR__))));
require_once BASE_PATH . '/app/config/config.php';

// Start session
if (session_status() === PHP_SESSION_NONE) {
    session_name(SESSION_NAME);
    session_start();
}

// Must be POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Invalid request']);
    exit;
}

// Must be admin
if (!isAdminLoggedIn()) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'অ্যাডমিন লগইন প্রয়োজন']);
    exit;
}

// Load service
require_once APP_PATH . '/services/promo_service.php';

// Get promo ID
$promoId = (int)post('promo_id');

if ($promoId < 1) {
    Response::error('অবৈধ প্রোমো কোড');
}

// Delete
$deleted = PromoService::delete($promoId);

if ($deleted) {
    Response::success('প্রোমো কোড মুছে ফেলা হয়েছে');
} else {
    Response::error('প্রোমো কোড মুছতে সমস্যা হয়েছে');
}
