<?php
/**
 * ============================================================
 * ADMIN AJAX: Approve/Reject Review
 * ============================================================
 */

// Initialize
define('BASE_PATH', dirname(dirname(dirname(__DIR__))));
require_once BASE_PATH . '/app/config/config.php';

// Start session
if (session_status() === PHP_SESSION_NONE) {
    session_name(SESSION_NAME);
    session_start();
}

// Must be POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Invalid request']);
    exit;
}

// Must be admin
if (!isAdminLoggedIn()) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'অ্যাডমিন লগইন প্রয়োজন']);
    exit;
}

// Load service
require_once APP_PATH . '/services/review_service.php';

// Get data
$reviewId = (int)post('review_id');
$action = sanitize(post('action')); // 'approve' or 'reject'

if ($reviewId < 1) {
    Response::error('অবৈধ রিভিউ');
}

if (!in_array($action, ['approve', 'reject'])) {
    Response::error('অবৈধ অ্যাকশন');
}

// Process
if ($action === 'approve') {
    $result = ReviewService::approve($reviewId, getAdminId());
} else {
    $result = ReviewService::reject($reviewId);
}

if ($result['success']) {
    Response::success($result['message']);
} else {
    Response::error($result['message']);
}
