<?php
/**
 * Admin Sidebar Navigation
 */

// Get pending counts for badges
require_once APP_PATH . '/services/order_service.php';
require_once APP_PATH . '/services/review_service.php';

$pendingOrders = (int)Database::fetchColumn("SELECT COUNT(*) FROM orders WHERE status = 'Pending'");
$pendingPayments = (int)Database::fetchColumn("SELECT COUNT(*) FROM orders WHERE payment_status = 'Submitted'");
$pendingReviews = ReviewService::getPendingCount();

// Current page
$currentPage = $_GET['page'] ?? 'dashboard';
?>

<!-- Sidebar -->
<nav class="admin-sidebar" id="adminSidebar">
    <div class="sidebar-header">
        <a href="<?= adminUrl() ?>" class="sidebar-brand">
            <i class="bi bi-shop"></i>
            <span><?= SITE_NAME ?></span>
        </a>
    </div>
    
    <ul class="sidebar-nav">
        <li class="nav-item">
            <a href="<?= adminUrl() ?>" class="nav-link <?= $currentPage === 'dashboard' ? 'active' : '' ?>">
                <i class="bi bi-speedometer2"></i>
                <span>Dashboard</span>
            </a>
        </li>
        
        <li class="nav-heading">Shop Management</li>
        
        <li class="nav-item">
            <a href="<?= adminUrl('?page=orders') ?>" class="nav-link <?= $currentPage === 'orders' ? 'active' : '' ?>">
                <i class="bi bi-bag-check"></i>
                <span>Orders</span>
                <?php if ($pendingOrders > 0): ?>
                <span class="badge bg-warning text-dark"><?= $pendingOrders ?></span>
                <?php endif; ?>
            </a>
        </li>
        
        <li class="nav-item">
            <a href="<?= adminUrl('?page=products') ?>" class="nav-link <?= in_array($currentPage, ['products', 'product-form']) ? 'active' : '' ?>">
                <i class="bi bi-box-seam"></i>
                <span>Products</span>
            </a>
        </li>
        
        <li class="nav-item">
            <a href="<?= adminUrl('?page=promo-codes') ?>" class="nav-link <?= $currentPage === 'promo-codes' ? 'active' : '' ?>">
                <i class="bi bi-ticket-perforated"></i>
                <span>Promo Codes</span>
            </a>
        </li>
        
        <li class="nav-heading">Customer Management</li>
        
        <li class="nav-item">
            <a href="<?= adminUrl('?page=users') ?>" class="nav-link <?= $currentPage === 'users' ? 'active' : '' ?>">
                <i class="bi bi-people"></i>
                <span>Users</span>
            </a>
        </li>
        
        <li class="nav-item">
            <a href="<?= adminUrl('?page=reviews') ?>" class="nav-link <?= $currentPage === 'reviews' ? 'active' : '' ?>">
                <i class="bi bi-star"></i>
                <span>Reviews</span>
                <?php if ($pendingReviews > 0): ?>
                <span class="badge bg-info"><?= $pendingReviews ?></span>
                <?php endif; ?>
            </a>
        </li>
        
        <li class="nav-heading">Settings</li>
        
        <li class="nav-item">
            <a href="<?= adminUrl('?page=settings') ?>" class="nav-link <?= $currentPage === 'settings' ? 'active' : '' ?>">
                <i class="bi bi-gear"></i>
                <span>Settings</span>
            </a>
        </li>
        
        <li class="nav-item">
            <a href="<?= url('public/') ?>" class="nav-link" target="_blank">
                <i class="bi bi-box-arrow-up-right"></i>
                <span>View Website</span>
            </a>
        </li>
    </ul>
</nav>
