<?php
/**
 * Admin Topbar
 */
$adminName = $_SESSION['admin_name'] ?? 'Admin';
?>

<!-- Topbar -->
<header class="admin-topbar">
    <div class="topbar-left">
        <button class="btn btn-link sidebar-toggle" type="button" id="sidebarToggle">
            <i class="bi bi-list fs-4"></i>
        </button>
        
        <nav aria-label="breadcrumb" class="d-none d-md-block">
            <ol class="breadcrumb mb-0">
                <li class="breadcrumb-item"><a href="<?= adminUrl() ?>">Admin</a></li>
                <li class="breadcrumb-item active"><?= sanitize($pageTitle ?? 'Dashboard') ?></li>
            </ol>
        </nav>
    </div>
    
    <div class="topbar-right">
        <!-- Quick Stats -->
        <div class="topbar-stats d-none d-lg-flex">
            <?php
            $pendingPaymentCount = (int)Database::fetchColumn("SELECT COUNT(*) FROM orders WHERE payment_status = 'Submitted'");
            if ($pendingPaymentCount > 0):
            ?>
            <a href="<?= adminUrl('?page=orders&filter=pending_payment') ?>" class="stat-item text-warning" title="Pending Payments">
                <i class="bi bi-wallet2"></i>
                <span><?= $pendingPaymentCount ?></span>
            </a>
            <?php endif; ?>
        </div>
        
        <!-- Admin Dropdown -->
        <div class="dropdown">
            <a href="#" class="admin-profile dropdown-toggle" data-bs-toggle="dropdown">
                <div class="avatar">
                    <i class="bi bi-person-circle"></i>
                </div>
                <span class="d-none d-md-inline"><?= sanitize($adminName) ?></span>
            </a>
            <ul class="dropdown-menu dropdown-menu-end">
                <li>
                    <a class="dropdown-item" href="<?= adminUrl('?page=settings') ?>">
                        <i class="bi bi-gear me-2"></i> Settings
                    </a>
                </li>
                <li><hr class="dropdown-divider"></li>
                <li>
                    <a class="dropdown-item text-danger" href="<?= adminUrl('auth/logout.php') ?>">
                        <i class="bi bi-box-arrow-right me-2"></i> Logout
                    </a>
                </li>
            </ul>
        </div>
    </div>
</header>
