<?php
/**
 * ============================================================
 * ADMIN PANEL - Main Entry Point
 * ============================================================
 */

// Initialize application
define('BASE_PATH', dirname(__DIR__));
require_once BASE_PATH . '/app/config/config.php';

// Start session
if (session_status() === PHP_SESSION_NONE) {
    session_name(SESSION_NAME);
    session_set_cookie_params([
        'lifetime' => SESSION_LIFETIME,
        'path' => '/',
        'secure' => SESSION_SECURE,
        'httponly' => SESSION_HTTPONLY,
        'samesite' => 'Lax'
    ]);
    session_start();
}

// Check admin authentication
require_once APP_PATH . '/middleware/require_admin.php';

// Generate CSRF token
CSRF::generateToken();

// Simple router
$page = isset($_GET['page']) ? sanitize($_GET['page']) : 'dashboard';

// Valid pages
$validPages = [
    'dashboard', 'products', 'product-form', 'orders', 'order-view',
    'promo-codes', 'users', 'reviews', 'settings'
];

if (!in_array($page, $validPages)) {
    $page = 'dashboard';
}

// Page file path
$pageFile = ADMIN_PATH . '/pages/' . $page . '.php';

if (!file_exists($pageFile)) {
    $pageFile = ADMIN_PATH . '/pages/dashboard.php';
}

// Include the page
require_once $pageFile;
