<?php
/**
 * ============================================================
 * ADMIN: Dashboard
 * ============================================================
 */

$pageTitle = 'Dashboard';

// Get stats
require_once APP_PATH . '/services/order_service.php';
$stats = OrderService::getStats();

// Recent orders
$recentOrders = OrderService::getAll([], 5, 0);

// Include layout
include ADMIN_PATH . '/includes/header.php';
include ADMIN_PATH . '/includes/sidebar.php';
?>

<main class="admin-main">
    <?php include ADMIN_PATH . '/includes/topbar.php'; ?>
    
    <div class="admin-content">
        <h1 class="page-title">Dashboard</h1>
        
        <!-- Stats Cards -->
        <div class="row g-4 mb-4">
            <div class="col-xl-3 col-md-6">
                <div class="stat-card primary">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <div class="stat-label">Total Orders</div>
                            <div class="stat-value"><?= number_format($stats['total_orders']) ?></div>
                        </div>
                        <div class="stat-icon text-primary">
                            <i class="bi bi-bag"></i>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-xl-3 col-md-6">
                <div class="stat-card success">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <div class="stat-label">Total Sales</div>
                            <div class="stat-value"><?= formatPrice($stats['total_sales']) ?></div>
                        </div>
                        <div class="stat-icon text-success">
                            <i class="bi bi-currency-dollar"></i>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-xl-3 col-md-6">
                <div class="stat-card warning">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <div class="stat-label">Pending Orders</div>
                            <div class="stat-value"><?= number_format($stats['pending_orders']) ?></div>
                        </div>
                        <div class="stat-icon text-warning">
                            <i class="bi bi-clock"></i>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-xl-3 col-md-6">
                <div class="stat-card info">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <div class="stat-label">Pending Payments</div>
                            <div class="stat-value"><?= number_format($stats['pending_payments']) ?></div>
                        </div>
                        <div class="stat-icon text-info">
                            <i class="bi bi-wallet2"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Today's Stats -->
        <div class="row g-4 mb-4">
            <div class="col-md-6">
                <div class="stat-card">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <div class="stat-label">Today's Orders</div>
                            <div class="stat-value"><?= number_format($stats['today_orders']) ?></div>
                        </div>
                        <div class="stat-icon">
                            <i class="bi bi-calendar-check"></i>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="stat-card">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <div class="stat-label">Today's Sales</div>
                            <div class="stat-value"><?= formatPrice($stats['today_sales']) ?></div>
                        </div>
                        <div class="stat-icon">
                            <i class="bi bi-graph-up"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Recent Orders -->
        <div class="admin-table">
            <div class="card-header-actions p-3">
                <h5 class="mb-0">Recent Orders</h5>
                <a href="<?= adminUrl('?page=orders') ?>" class="btn btn-sm btn-outline-primary">View All</a>
            </div>
            
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Order No</th>
                            <th>Customer</th>
                            <th>Amount</th>
                            <th>Status</th>
                            <th>Payment</th>
                            <th>Date</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($recentOrders)): ?>
                        <tr>
                            <td colspan="7" class="text-center text-muted py-4">No orders yet</td>
                        </tr>
                        <?php else: ?>
                        <?php foreach ($recentOrders as $order): ?>
                        <tr>
                            <td><strong><?= sanitize($order['order_no']) ?></strong></td>
                            <td><?= sanitize($order['user_name']) ?></td>
                            <td><?= formatPrice($order['grand_total']) ?></td>
                            <td>
                                <span class="badge <?= getOrderStatusBadge($order['status']) ?>">
                                    <?= $order['status'] ?>
                                </span>
                            </td>
                            <td>
                                <span class="badge <?= getPaymentStatusBadge($order['payment_status']) ?>">
                                    <?= $order['payment_status'] ?>
                                </span>
                            </td>
                            <td><?= formatDate($order['created_at']) ?></td>
                            <td>
                                <a href="<?= adminUrl('?page=order-view&id=' . $order['id']) ?>" 
                                   class="btn btn-sm btn-outline-primary">
                                    <i class="bi bi-eye"></i>
                                </a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</main>

<!-- Sidebar Overlay (Mobile) -->
<div class="sidebar-overlay"></div>

<?php include ADMIN_PATH . '/includes/footer.php'; ?>
