<?php
/**
 * ============================================================
 * ADMIN: Order Details View
 * ============================================================
 */

require_once APP_PATH . '/services/order_service.php';

$orderId = (int)($_GET['id'] ?? 0);

if (!$orderId) {
    redirect(adminUrl('?page=orders'));
}

$order = OrderService::getById($orderId);

if (!$order) {
    redirect(adminUrl('?page=orders'));
}

$pageTitle = 'Order #' . $order['order_no'];

include ADMIN_PATH . '/includes/header.php';
include ADMIN_PATH . '/includes/sidebar.php';
?>

<main class="admin-main">
    <?php include ADMIN_PATH . '/includes/topbar.php'; ?>
    
    <div class="admin-content">
        <!-- Header -->
        <div class="d-flex justify-content-between align-items-center mb-4">
            <div>
                <a href="<?= adminUrl('?page=orders') ?>" class="text-muted text-decoration-none">
                    <i class="bi bi-arrow-left me-1"></i> Back to Orders
                </a>
                <h1 class="page-title mb-0 mt-2">Order #<?= sanitize($order['order_no']) ?></h1>
            </div>
            <div>
                <span class="badge <?= getOrderStatusBadge($order['status']) ?> fs-6 me-2">
                    <?= $order['status'] ?>
                </span>
                <span class="badge <?= getPaymentStatusBadge($order['payment_status']) ?> fs-6">
                    <?= $order['payment_status'] ?>
                </span>
            </div>
        </div>
        
        <div class="row g-4">
            <!-- Left Column -->
            <div class="col-lg-8">
                <!-- Order Items -->
                <div class="admin-form mb-4">
                    <h5 class="mb-3">Order Items</h5>
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Product</th>
                                    <th>Price</th>
                                    <th>Qty</th>
                                    <th class="text-end">Total</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($order['items'] as $item): ?>
                                <tr>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <?php if ($item['image']): ?>
                                            <img src="<?= UPLOADS_URL . '/products/' . $item['image'] ?>" 
                                                 alt="" class="rounded me-2" width="50" height="50" style="object-fit: cover;">
                                            <?php endif; ?>
                                            <div>
                                                <strong><?= sanitize($item['product_name']) ?></strong>
                                                <?php if ($item['product_sku']): ?>
                                                <small class="d-block text-muted">SKU: <?= sanitize($item['product_sku']) ?></small>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </td>
                                    <td><?= formatPrice($item['unit_price']) ?></td>
                                    <td><?= $item['qty'] ?></td>
                                    <td class="text-end"><strong><?= formatPrice($item['line_total']) ?></strong></td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td colspan="3" class="text-end">Subtotal</td>
                                    <td class="text-end"><?= formatPrice($order['subtotal']) ?></td>
                                </tr>
                                <tr>
                                    <td colspan="3" class="text-end">VAT (<?= $order['vat_percent'] ?>%)</td>
                                    <td class="text-end"><?= formatPrice($order['vat_amount']) ?></td>
                                </tr>
                                <?php if ($order['discount_amount'] > 0): ?>
                                <tr class="text-success">
                                    <td colspan="3" class="text-end">
                                        Discount
                                        <?php if ($order['promo_code']): ?>
                                        <small>(<?= sanitize($order['promo_code']) ?>)</small>
                                        <?php endif; ?>
                                    </td>
                                    <td class="text-end">-<?= formatPrice($order['discount_amount']) ?></td>
                                </tr>
                                <?php endif; ?>
                                <tr class="fw-bold fs-5">
                                    <td colspan="3" class="text-end">Grand Total</td>
                                    <td class="text-end text-primary"><?= formatPrice($order['grand_total']) ?></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
                
                <!-- Payment Details -->
                <div class="admin-form mb-4">
                    <h5 class="mb-3">Payment Details</h5>
                    
                    <?php if (empty($order['payments'])): ?>
                    <div class="alert alert-warning">
                        <i class="bi bi-exclamation-triangle me-2"></i>
                        No payment submitted yet.
                    </div>
                    <?php else: ?>
                    <?php foreach ($order['payments'] as $payment): ?>
                    <div class="payment-info-card">
                        <div class="row">
                            <div class="col-md-6">
                                <p class="mb-1"><strong>Method:</strong> <?= $payment['method'] ?></p>
                                <p class="mb-1"><strong>Sender Mobile:</strong> <?= sanitize($payment['sender_mobile']) ?></p>
                                <p class="mb-1"><strong>Transaction ID:</strong> 
                                    <code class="fs-6"><?= sanitize($payment['trx_id']) ?></code>
                                </p>
                                <p class="mb-1"><strong>Amount:</strong> <?= $payment['amount'] ?></p>
                            </div>
                            <div class="col-md-6">
                                <p class="mb-1"><strong>Status:</strong> 
                                    <span class="badge <?= getPaymentStatusBadge($payment['status']) ?>">
                                        <?= $payment['status'] ?>
                                    </span>
                                </p>
                                <p class="mb-1"><strong>Submitted:</strong> <?= $payment['submitted_at'] ?? '-' ?></p>
                                <?php if (!empty($payment['verified_at'])): ?>
                                <p class="mb-1"><strong>Verified:</strong> <?= $payment['verified_at'] ?></p>
                                <p class="mb-1"><strong>Verified By:</strong> <?= sanitize($payment['verified_by'] ?? '') ?></p>
                                <?php endif; ?>
                                <?php if (!empty($payment['admin_note'])): ?>
                                <p class="mb-0"><strong>Note:</strong> <?= sanitize($payment['admin_note']) ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                        
                        <?php if ($payment['status'] === 'Submitted'): ?>
                        <hr>
                        <div class="d-flex gap-2">
                            <button type="button" class="btn btn-success btn-verify-payment"
                                    data-payment-id="<?= $payment['id'] ?>" data-action="verify">
                                <i class="bi bi-check-circle me-1"></i> Verify Payment
                            </button>
                            <button type="button" class="btn btn-danger btn-verify-payment"
                                    data-payment-id="<?= $payment['id'] ?>" data-action="reject">
                                <i class="bi bi-x-circle me-1"></i> Reject
                            </button>
                        </div>
                        <?php endif; ?>
                    </div>
                    <?php endforeach; ?>
                    <?php endif; ?>
                </div>
                
                <!-- Status History -->
                <div class="admin-form">
                    <h5 class="mb-3">Status History</h5>
                    <div class="order-timeline">
                        <?php foreach ($order['status_history'] as $index => $history): ?>
                        <div class="order-timeline-item <?= $index === count($order['status_history']) - 1 ? 'current' : 'completed' ?>">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <strong><?= $history['status'] ?></strong>
                                    <?php if (!empty($history['note'])): ?>
                                    <p class="mb-0 text-muted small"><?= sanitize($history['note']) ?></p>
                                    <?php endif; ?>
                                </div>
                                <div class="text-muted small text-end">
                                    <?= $history['created_at'] ?>
                                    <?php if (!empty($history['changed_by_name'])): ?>
                                    <br>by <?= sanitize($history['changed_by_name']) ?>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
            
            <!-- Right Column -->
            <div class="col-lg-4">
                <!-- Customer Info -->
                <div class="admin-form mb-4">
                    <h5 class="mb-3">Customer</h5>
                    <p class="mb-1"><strong><?= sanitize($order['user_name']) ?></strong></p>
                    <p class="mb-1"><i class="bi bi-envelope me-2"></i><?= sanitize($order['user_email']) ?></p>
                    <p class="mb-0"><i class="bi bi-telephone me-2"></i><?= sanitize($order['user_phone']) ?></p>
                </div>
                
                <!-- Shipping Info -->
                <div class="admin-form mb-4">
                    <h5 class="mb-3">Shipping Address</h5>
                    <p class="mb-1"><strong><?= sanitize($order['shipping_name']) ?></strong></p>
                    <p class="mb-1"><i class="bi bi-telephone me-2"></i><?= sanitize($order['shipping_phone']) ?></p>
                    <?php if ($order['shipping_email']): ?>
                    <p class="mb-1"><i class="bi bi-envelope me-2"></i><?= sanitize($order['shipping_email']) ?></p>
                    <?php endif; ?>
                    <p class="mb-1">
                        <i class="bi bi-geo-alt me-2"></i>
                        <?= sanitize($order['shipping_address']) ?>
                        <?php if ($order['shipping_area']): ?>, <?= sanitize($order['shipping_area']) ?><?php endif; ?>
                        <?php if ($order['shipping_city']): ?>, <?= sanitize($order['shipping_city']) ?><?php endif; ?>
                    </p>
                </div>
                
                <!-- Order Notes -->
                <?php if ($order['notes']): ?>
                <div class="admin-form mb-4">
                    <h5 class="mb-3">Order Notes</h5>
                    <p class="mb-0"><?= nl2br(sanitize($order['notes'])) ?></p>
                </div>
                <?php endif; ?>
                
                <!-- Actions -->
                <div class="admin-form">
                    <h5 class="mb-3">Actions</h5>
                    <div class="d-grid gap-2">
                        <button type="button" class="btn btn-primary btn-change-status"
                                data-order-id="<?= $order['id'] ?>"
                                data-current-status="<?= $order['status'] ?>">
                            <i class="bi bi-arrow-repeat me-2"></i>Change Status
                        </button>
                        <button type="button" class="btn btn-outline-secondary" onclick="window.print()">
                            <i class="bi bi-printer me-2"></i>Print Order
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<div class="sidebar-overlay"></div>

<?php include ADMIN_PATH . '/includes/footer.php'; ?>
