<?php
/**
 * ============================================================
 * ADMIN: Orders List
 * ============================================================
 */

$pageTitle = 'Orders';

require_once APP_PATH . '/services/order_service.php';

// Filters
$filters = [];
if (!empty($_GET['status'])) {
    $filters['status'] = sanitize($_GET['status']);
}
if (!empty($_GET['payment_status'])) {
    $filters['payment_status'] = sanitize($_GET['payment_status']);
}
if (!empty($_GET['search'])) {
    $filters['search'] = sanitize($_GET['search']);
}

// Pagination
$page = max(1, (int)($_GET['p'] ?? 1));
$limit = ORDERS_PER_PAGE;
$offset = ($page - 1) * $limit;

// Get orders
$orders = OrderService::getAll($filters, $limit, $offset);

include ADMIN_PATH . '/includes/header.php';
include ADMIN_PATH . '/includes/sidebar.php';
?>

<main class="admin-main">
    <?php include ADMIN_PATH . '/includes/topbar.php'; ?>
    
    <div class="admin-content">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h1 class="page-title mb-0">Orders</h1>
        </div>
        
        <!-- Filters -->
        <div class="admin-form mb-4">
            <form method="GET" class="row g-3">
                <input type="hidden" name="page" value="orders">
                
                <div class="col-md-3">
                    <input type="text" class="form-control" name="search" 
                           value="<?= sanitize($filters['search'] ?? '') ?>" 
                           placeholder="Search order no, name, phone...">
                </div>
                
                <div class="col-md-2">
                    <select class="form-select" name="status">
                        <option value="">All Status</option>
                        <option value="Pending" <?= ($filters['status'] ?? '') === 'Pending' ? 'selected' : '' ?>>Pending</option>
                        <option value="Processing" <?= ($filters['status'] ?? '') === 'Processing' ? 'selected' : '' ?>>Processing</option>
                        <option value="Shipped" <?= ($filters['status'] ?? '') === 'Shipped' ? 'selected' : '' ?>>Shipped</option>
                        <option value="Delivered" <?= ($filters['status'] ?? '') === 'Delivered' ? 'selected' : '' ?>>Delivered</option>
                        <option value="Cancelled" <?= ($filters['status'] ?? '') === 'Cancelled' ? 'selected' : '' ?>>Cancelled</option>
                    </select>
                </div>
                
                <div class="col-md-2">
                    <select class="form-select" name="payment_status">
                        <option value="">All Payment</option>
                        <option value="Unpaid" <?= ($filters['payment_status'] ?? '') === 'Unpaid' ? 'selected' : '' ?>>Unpaid</option>
                        <option value="Submitted" <?= ($filters['payment_status'] ?? '') === 'Submitted' ? 'selected' : '' ?>>Submitted</option>
                        <option value="Verified" <?= ($filters['payment_status'] ?? '') === 'Verified' ? 'selected' : '' ?>>Verified</option>
                        <option value="Rejected" <?= ($filters['payment_status'] ?? '') === 'Rejected' ? 'selected' : '' ?>>Rejected</option>
                    </select>
                </div>
                
                <div class="col-md-2">
                    <button type="submit" class="btn btn-primary w-100">
                        <i class="bi bi-search me-1"></i> Filter
                    </button>
                </div>
                
                <div class="col-md-2">
                    <a href="<?= adminUrl('?page=orders') ?>" class="btn btn-outline-secondary w-100">Reset</a>
                </div>
            </form>
        </div>
        
        <!-- Orders Table -->
        <div class="admin-table">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Order No</th>
                            <th>Customer</th>
                            <th>Items</th>
                            <th>Total</th>
                            <th>Payment</th>
                            <th>Status</th>
                            <th>Date</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($orders)): ?>
                        <tr>
                            <td colspan="8" class="text-center text-muted py-4">No orders found</td>
                        </tr>
                        <?php else: ?>
                        <?php foreach ($orders as $order): ?>
                        <tr>
                            <td>
                                <strong><?= sanitize($order['order_no']) ?></strong>
                                <small class="d-block text-muted"><?= $order['payment_method'] ?></small>
                            </td>
                            <td>
                                <?= sanitize($order['user_name']) ?>
                                <small class="d-block text-muted"><?= sanitize($order['shipping_phone']) ?></small>
                            </td>
                            <td>
                                <?php
                                $itemCount = Database::fetchColumn(
                                    "SELECT SUM(qty) FROM order_items WHERE order_id = ?",
                                    [$order['id']]
                                );
                                echo $itemCount . ' items';
                                ?>
                            </td>
                            <td><strong><?= formatPrice($order['grand_total']) ?></strong></td>
                            <td>
                                <span class="badge <?= getPaymentStatusBadge($order['payment_status']) ?>">
                                    <?= $order['payment_status'] ?>
                                </span>
                            </td>
                            <td>
                                <span class="badge <?= getOrderStatusBadge($order['status']) ?>">
                                    <?= $order['status'] ?>
                                </span>
                            </td>
                            <td>
                                <?= formatDate($order['created_at']) ?>
                                <small class="d-block text-muted"><?= date('h:i A', strtotime($order['created_at'])) ?></small>
                            </td>
                            <td>
                                <div class="btn-group btn-group-sm">
                                    <a href="<?= adminUrl('?page=order-view&id=' . $order['id']) ?>" 
                                       class="btn btn-outline-primary" title="View">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                    <button type="button" class="btn btn-outline-secondary btn-change-status"
                                            data-order-id="<?= $order['id'] ?>"
                                            data-current-status="<?= $order['status'] ?>"
                                            title="Change Status">
                                        <i class="bi bi-arrow-repeat"></i>
                                    </button>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</main>

<div class="sidebar-overlay"></div>

<?php include ADMIN_PATH . '/includes/footer.php'; ?>
