<?php
/**
 * ============================================================
 * ADMIN: Products List
 * ============================================================
 */

$pageTitle = 'Products';

require_once APP_PATH . '/services/product_service.php';

// Pagination
$page = max(1, (int)($_GET['p'] ?? 1));
$limit = 20;
$offset = ($page - 1) * $limit;

// Get products
$products = ProductService::getAllAdmin($limit, $offset);

// Get categories for filter
$categories = Database::fetchAll("SELECT id, name FROM categories WHERE is_active = 1 ORDER BY name");

include ADMIN_PATH . '/includes/header.php';
include ADMIN_PATH . '/includes/sidebar.php';
?>

<main class="admin-main">
    <?php include ADMIN_PATH . '/includes/topbar.php'; ?>
    
    <div class="admin-content">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h1 class="page-title mb-0">Products</h1>
            <a href="<?= adminUrl('?page=product-form') ?>" class="btn btn-primary">
                <i class="bi bi-plus-lg me-1"></i> Add Product
            </a>
        </div>
        
        <!-- Products Table -->
        <div class="admin-table">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th style="width: 60px;">Image</th>
                            <th>Name</th>
                            <th>Category</th>
                            <th>Price</th>
                            <th>Stock</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($products)): ?>
                        <tr>
                            <td colspan="7" class="text-center text-muted py-4">No products found</td>
                        </tr>
                        <?php else: ?>
                        <?php foreach ($products as $product): ?>
                        <tr>
                            <td>
                                <?php if ($product['primary_image']): ?>
                                <img src="<?= UPLOADS_URL . '/products/' . $product['primary_image'] ?>" 
                                     alt="" class="rounded" width="50" height="50" style="object-fit: cover;">
                                <?php else: ?>
                                <div class="bg-light rounded d-flex align-items-center justify-content-center" 
                                     style="width: 50px; height: 50px;">
                                    <i class="bi bi-image text-muted"></i>
                                </div>
                                <?php endif; ?>
                            </td>
                            <td>
                                <strong><?= sanitize($product['name']) ?></strong>
                                <?php if ($product['sku']): ?>
                                <small class="d-block text-muted">SKU: <?= sanitize($product['sku']) ?></small>
                                <?php endif; ?>
                                <?php if ($product['is_featured']): ?>
                                <span class="badge bg-warning text-dark">Featured</span>
                                <?php endif; ?>
                            </td>
                            <td><?= sanitize($product['category_name']) ?></td>
                            <td>
                                <?php if ($product['sale_price']): ?>
                                <span class="text-danger"><?= formatPrice($product['sale_price']) ?></span>
                                <small class="text-muted text-decoration-line-through d-block">
                                    <?= formatPrice($product['price']) ?>
                                </small>
                                <?php else: ?>
                                <?= formatPrice($product['price']) ?>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if ($product['stock_qty'] > 10): ?>
                                <span class="text-success"><?= $product['stock_qty'] ?></span>
                                <?php elseif ($product['stock_qty'] > 0): ?>
                                <span class="text-warning"><?= $product['stock_qty'] ?></span>
                                <?php else: ?>
                                <span class="text-danger">Out of Stock</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if ($product['is_active']): ?>
                                <span class="badge bg-success">Active</span>
                                <?php else: ?>
                                <span class="badge bg-secondary">Inactive</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="btn-group btn-group-sm">
                                    <a href="<?= adminUrl('?page=product-form&id=' . $product['id']) ?>" 
                                       class="btn btn-outline-primary" title="Edit">
                                        <i class="bi bi-pencil"></i>
                                    </a>
                                    <button type="button" class="btn btn-outline-danger btn-delete"
                                            data-url="<?= adminUrl('ajax/products/delete.php') ?>"
                                            data-product-id="<?= $product['id'] ?>"
                                            data-type="Product"
                                            title="Delete">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</main>

<div class="sidebar-overlay"></div>

<?php include ADMIN_PATH . '/includes/footer.php'; ?>
