<?php
/**
 * ============================================================
 * ADMIN: Promo Codes
 * ============================================================
 */

$pageTitle = 'Promo Codes';

require_once APP_PATH . '/services/promo_service.php';

$promos = PromoService::getAll();

include ADMIN_PATH . '/includes/header.php';
include ADMIN_PATH . '/includes/sidebar.php';
?>

<main class="admin-main">
    <?php include ADMIN_PATH . '/includes/topbar.php'; ?>
    
    <div class="admin-content">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h1 class="page-title mb-0">Promo Codes</h1>
            <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#promoModal">
                <i class="bi bi-plus-lg me-1"></i> Add Promo Code
            </button>
        </div>
        
        <div class="admin-table">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Code</th>
                            <th>Discount</th>
                            <th>Min Order</th>
                            <th>Usage</th>
                            <th>Expiry</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($promos)): ?>
                        <tr>
                            <td colspan="7" class="text-center text-muted py-4">No promo codes</td>
                        </tr>
                        <?php else: ?>
                        <?php foreach ($promos as $promo): ?>
                        <tr>
                            <td>
                                <code class="fs-6"><?= sanitize($promo['code']) ?></code>
                                <?php if ($promo['description']): ?>
                                <small class="d-block text-muted"><?= sanitize($promo['description']) ?></small>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if ($promo['discount_type'] === 'percent'): ?>
                                <?= $promo['discount_value'] ?>%
                                <?php if ($promo['max_discount_amount']): ?>
                                <small class="d-block text-muted">Max: <?= formatPrice($promo['max_discount_amount']) ?></small>
                                <?php endif; ?>
                                <?php else: ?>
                                <?= formatPrice($promo['discount_value']) ?>
                                <?php endif; ?>
                            </td>
                            <td><?= formatPrice($promo['min_order_amount']) ?></td>
                            <td>
                                <?= $promo['used_count'] ?>
                                <?php if ($promo['usage_limit']): ?>
                                / <?= $promo['usage_limit'] ?>
                                <?php else: ?>
                                / ∞
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if ($promo['expires_at']): ?>
                                    <?php if (strtotime($promo['expires_at']) < time()): ?>
                                    <span class="text-danger">Expired</span>
                                    <?php else: ?>
                                    <?= formatDate($promo['expires_at']) ?>
                                    <?php endif; ?>
                                <?php else: ?>
                                <span class="text-muted">No expiry</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if ($promo['is_active']): ?>
                                <span class="badge bg-success">Active</span>
                                <?php else: ?>
                                <span class="badge bg-secondary">Inactive</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="btn-group btn-group-sm">
                                    <button type="button" class="btn btn-outline-primary btn-edit-promo"
                                            data-promo='<?= json_encode($promo) ?>' title="Edit">
                                        <i class="bi bi-pencil"></i>
                                    </button>
                                    <button type="button" class="btn btn-outline-danger btn-delete"
                                            data-url="<?= adminUrl('ajax/promo/delete.php') ?>"
                                            data-promo-id="<?= $promo['id'] ?>"
                                            data-type="Promo Code" title="Delete">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</main>

<!-- Promo Code Modal -->
<div class="modal fade" id="promoModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="promoForm" action="<?= adminUrl('ajax/promo/create.php') ?>" method="POST">
                <?= csrf_field() ?>
                <input type="hidden" name="promo_id" id="promo_id" value="">
                
                <div class="modal-header">
                    <h5 class="modal-title" id="promoModalTitle">Add Promo Code</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="code" class="form-label">Code <span class="text-danger">*</span></label>
                        <input type="text" class="form-control text-uppercase" id="code" name="code" required>
                    </div>
                    
                    <div class="mb-3">
                        <label for="description" class="form-label">Description</label>
                        <input type="text" class="form-control" id="promo_description" name="description">
                    </div>
                    
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label for="discount_type" class="form-label">Discount Type</label>
                            <select class="form-select" id="discount_type" name="discount_type">
                                <option value="percent">Percentage (%)</option>
                                <option value="fixed">Fixed Amount (৳)</option>
                            </select>
                        </div>
                        
                        <div class="col-md-6">
                            <label for="discount_value" class="form-label">Value <span class="text-danger">*</span></label>
                            <input type="number" class="form-control" id="discount_value" name="discount_value" 
                                   step="0.01" min="0" required>
                        </div>
                    </div>
                    
                    <div class="row g-3 mt-1">
                        <div class="col-md-6">
                            <label for="min_order_amount" class="form-label">Min Order Amount</label>
                            <input type="number" class="form-control" id="min_order_amount" name="min_order_amount" 
                                   step="0.01" min="0" value="0">
                        </div>
                        
                        <div class="col-md-6">
                            <label for="max_discount_amount" class="form-label">Max Discount</label>
                            <input type="number" class="form-control" id="max_discount_amount" name="max_discount_amount" 
                                   step="0.01" min="0">
                            <small class="text-muted">For percentage discounts</small>
                        </div>
                    </div>
                    
                    <div class="row g-3 mt-1">
                        <div class="col-md-6">
                            <label for="usage_limit" class="form-label">Usage Limit</label>
                            <input type="number" class="form-control" id="usage_limit" name="usage_limit" min="0">
                            <small class="text-muted">Leave empty for unlimited</small>
                        </div>
                        
                        <div class="col-md-6">
                            <label for="expires_at" class="form-label">Expiry Date</label>
                            <input type="datetime-local" class="form-control" id="expires_at" name="expires_at">
                        </div>
                    </div>
                    
                    <div class="form-check form-switch mt-3">
                        <input class="form-check-input" type="checkbox" id="is_active" name="is_active" value="1" checked>
                        <label class="form-check-label" for="is_active">Active</label>
                    </div>
                </div>
                
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Save</button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="sidebar-overlay"></div>

<script>
// Edit promo - populate modal
$(document).on('click', '.btn-edit-promo', function() {
    const promo = $(this).data('promo');
    
    $('#promo_id').val(promo.id);
    $('#code').val(promo.code);
    $('#promo_description').val(promo.description);
    $('#discount_type').val(promo.discount_type);
    $('#discount_value').val(promo.discount_value);
    $('#min_order_amount').val(promo.min_order_amount);
    $('#max_discount_amount').val(promo.max_discount_amount);
    $('#usage_limit').val(promo.usage_limit);
    $('#expires_at').val(promo.expires_at ? promo.expires_at.replace(' ', 'T').slice(0, 16) : '');
    $('#is_active').prop('checked', promo.is_active == 1);
    
    $('#promoModalTitle').text('Edit Promo Code');
    $('#promoForm').attr('action', '<?= adminUrl('ajax/promo/update.php') ?>');
    
    $('#promoModal').modal('show');
});

// Reset modal on close
$('#promoModal').on('hidden.bs.modal', function() {
    $('#promoForm')[0].reset();
    $('#promo_id').val('');
    $('#promoModalTitle').text('Add Promo Code');
    $('#promoForm').attr('action', '<?= adminUrl('ajax/promo/create.php') ?>');
    $('#is_active').prop('checked', true);
});
</script>

<?php include ADMIN_PATH . '/includes/footer.php'; ?>
