<?php
/**
 * ============================================================
 * ADMIN: Reviews Management
 * ============================================================
 */

$pageTitle = 'Reviews';

require_once APP_PATH . '/services/review_service.php';

// Filter
$filter = sanitize($_GET['filter'] ?? 'pending');
$filters = ['is_approved' => $filter === 'approved' ? 1 : 0];

if ($filter === 'all') {
    $filters = [];
}

$reviews = ReviewService::getAllAdmin($filters, 50, 0);

include ADMIN_PATH . '/includes/header.php';
include ADMIN_PATH . '/includes/sidebar.php';
?>

<main class="admin-main">
    <?php include ADMIN_PATH . '/includes/topbar.php'; ?>
    
    <div class="admin-content">
        <h1 class="page-title">Reviews</h1>
        
        <!-- Filter Tabs -->
        <ul class="nav nav-tabs mb-4">
            <li class="nav-item">
                <a class="nav-link <?= $filter === 'pending' ? 'active' : '' ?>" 
                   href="<?= adminUrl('?page=reviews&filter=pending') ?>">
                    Pending Approval
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?= $filter === 'approved' ? 'active' : '' ?>" 
                   href="<?= adminUrl('?page=reviews&filter=approved') ?>">
                    Approved
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?= $filter === 'all' ? 'active' : '' ?>" 
                   href="<?= adminUrl('?page=reviews&filter=all') ?>">
                    All
                </a>
            </li>
        </ul>
        
        <div class="admin-table">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Product</th>
                            <th>User</th>
                            <th>Rating</th>
                            <th>Review</th>
                            <th>Date</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($reviews)): ?>
                        <tr>
                            <td colspan="7" class="text-center text-muted py-4">No reviews found</td>
                        </tr>
                        <?php else: ?>
                        <?php foreach ($reviews as $review): ?>
                        <tr>
                            <td>
                                <a href="<?= url('public/?page=product&id=' . $review['product_id']) ?>" target="_blank">
                                    <?= sanitize(truncate($review['product_name'], 30)) ?>
                                </a>
                            </td>
                            <td><?= sanitize($review['user_name']) ?></td>
                            <td>
                                <span class="text-warning">
                                    <?php for ($i = 1; $i <= 5; $i++): ?>
                                    <i class="bi bi-star<?= $i <= $review['rating'] ? '-fill' : '' ?>"></i>
                                    <?php endfor; ?>
                                </span>
                            </td>
                            <td>
                                <?php if ($review['review_title']): ?>
                                <strong><?= sanitize($review['review_title']) ?></strong><br>
                                <?php endif; ?>
                                <small><?= sanitize(truncate($review['review_text'] ?? '', 100)) ?></small>
                            </td>
                            <td><?= formatDate($review['created_at']) ?></td>
                            <td>
                                <?php if ($review['is_approved']): ?>
                                <span class="badge bg-success">Approved</span>
                                <?php else: ?>
                                <span class="badge bg-warning text-dark">Pending</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if (!$review['is_approved']): ?>
                                <div class="btn-group btn-group-sm">
                                    <button type="button" class="btn btn-outline-success btn-review-action"
                                            data-review-id="<?= $review['id'] ?>" data-action="approve" title="Approve">
                                        <i class="bi bi-check"></i>
                                    </button>
                                    <button type="button" class="btn btn-outline-danger btn-review-action"
                                            data-review-id="<?= $review['id'] ?>" data-action="reject" title="Delete">
                                        <i class="bi bi-x"></i>
                                    </button>
                                </div>
                                <?php else: ?>
                                <button type="button" class="btn btn-sm btn-outline-danger btn-review-action"
                                        data-review-id="<?= $review['id'] ?>" data-action="reject" title="Delete">
                                    <i class="bi bi-trash"></i>
                                </button>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</main>

<div class="sidebar-overlay"></div>

<?php include ADMIN_PATH . '/includes/footer.php'; ?>
