<?php
/**
 * ADMIN: Settings Page - Editable
 */

$pageTitle = 'Settings';

// Get site settings from database
$settings = [];
try {
    $rows = Database::fetchAll("SELECT setting_key, setting_value FROM site_settings");
    foreach ($rows as $row) {
        $settings[$row['setting_key']] = $row['setting_value'];
    }
} catch (Exception $e) {
    // Table might not exist yet
}

// Helper to get setting value
function getSetting($key, $default = '') {
    global $settings;
    return $settings[$key] ?? $default;
}

include ADMIN_PATH . '/includes/header.php';
include ADMIN_PATH . '/includes/sidebar.php';
?>

<main class="admin-main">
    <?php include ADMIN_PATH . '/includes/topbar.php'; ?>
    
    <div class="admin-content">
        <h1 class="page-title">Settings</h1>
        
        <form id="settingsForm">
            <div class="row g-4">
                <!-- Shop Information -->
                <div class="col-lg-6">
                    <div class="admin-form">
                        <h5 class="mb-4"><i class="bi bi-shop me-2"></i>Shop Information</h5>
                        
                        <div class="mb-3">
                            <label class="form-label">Shop Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="site_name" 
                                   value="<?= sanitize(getSetting('site_name', SITE_NAME)) ?>" required>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Shop Email <span class="text-danger">*</span></label>
                            <input type="email" class="form-control" name="site_email" 
                                   value="<?= sanitize(getSetting('site_email', 'info@safamodesthouse.com')) ?>" required>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Phone Number <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="site_phone" 
                                   value="<?= sanitize(getSetting('site_phone', '+880 1XXX-XXXXXX')) ?>" required>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Shop Address</label>
                            <textarea class="form-control" name="site_address" rows="2"><?= sanitize(getSetting('site_address', 'Dhaka, Bangladesh')) ?></textarea>
                        </div>
                    </div>
                </div>
                
                <!-- Payment & Shipping -->
                <div class="col-lg-6">
                    <div class="admin-form">
                        <h5 class="mb-4"><i class="bi bi-credit-card me-2"></i>Payment & Shipping</h5>
                        
                        <div class="mb-3">
                            <label class="form-label">bKash Number <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="bkash_number" 
                                   value="<?= sanitize(getSetting('bkash_number', BKASH_MERCHANT_NUMBER)) ?>" required>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Nagad Number <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="nagad_number" 
                                   value="<?= sanitize(getSetting('nagad_number', NAGAD_MERCHANT_NUMBER)) ?>" required>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">WhatsApp Number</label>
                            <input type="text" class="form-control" name="whatsapp_number" 
                                   value="<?= sanitize(getSetting('whatsapp_number', WHATSAPP_NUMBER)) ?>">
                        </div>
                        
                        <div class="row">
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label class="form-label">VAT %</label>
                                    <input type="number" class="form-control" name="vat_percent" 
                                           value="<?= (int)getSetting('vat_percent', VAT_PERCENT) ?>" min="0" max="100">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label class="form-label">Shipping (Dhaka)</label>
                                    <input type="number" class="form-control" name="shipping_dhaka" 
                                           value="<?= (int)getSetting('shipping_dhaka', SHIPPING_COST_DHAKA) ?>" min="0">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label class="form-label">Shipping (Outside)</label>
                                    <input type="number" class="form-control" name="shipping_outside" 
                                           value="<?= (int)getSetting('shipping_outside', SHIPPING_COST_OUTSIDE) ?>" min="0">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
                <!-- Social Media & Footer -->
                <div class="col-lg-6">
                    <div class="admin-form">
                        <h5 class="mb-4"><i class="bi bi-share me-2"></i>Social Media</h5>
                        
                        <div class="mb-3">
                            <label class="form-label">Facebook URL</label>
                            <input type="url" class="form-control" name="facebook_url" 
                                   value="<?= sanitize(getSetting('facebook_url', '')) ?>" placeholder="https://facebook.com/yourpage">
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Instagram URL</label>
                            <input type="url" class="form-control" name="instagram_url" 
                                   value="<?= sanitize(getSetting('instagram_url', '')) ?>" placeholder="https://instagram.com/yourpage">
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">YouTube URL</label>
                            <input type="url" class="form-control" name="youtube_url" 
                                   value="<?= sanitize(getSetting('youtube_url', '')) ?>" placeholder="https://youtube.com/yourchannel">
                        </div>
                    </div>
                </div>
                
                <!-- Footer Content -->
                <div class="col-lg-6">
                    <div class="admin-form">
                        <h5 class="mb-4"><i class="bi bi-file-text me-2"></i>Footer Content</h5>
                        
                        <div class="mb-3">
                            <label class="form-label">Footer About Text</label>
                            <textarea class="form-control" name="footer_about" rows="3"><?= sanitize(getSetting('footer_about', 'আমাদের কাছে পাবেন সেরা মানের পোশাক ও আনুষাঙ্গিক সামগ্রী।')) ?></textarea>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Business Hours</label>
                            <input type="text" class="form-control" name="business_hours" 
                                   value="<?= sanitize(getSetting('business_hours', 'সকাল ১০টা - রাত ১০টা')) ?>">
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Copyright Text</label>
                            <input type="text" class="form-control" name="copyright_text" 
                                   value="<?= sanitize(getSetting('copyright_text', 'সর্বস্বত্ব সংরক্ষিত।')) ?>">
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="mt-4">
                <button type="submit" class="btn btn-primary btn-lg">
                    <i class="bi bi-check-lg me-2"></i>Save Settings
                </button>
            </div>
        </form>
    </div>
</main>

<div class="sidebar-overlay"></div>

<?php include ADMIN_PATH . '/includes/footer.php'; ?>

<script>
$(function() {
    $('#settingsForm').on('submit', function(e) {
        e.preventDefault();
        
        var btn = $(this).find('button[type="submit"]');
        var originalText = btn.html();
        btn.html('<span class="spinner-border spinner-border-sm me-2"></span>Saving...').prop('disabled', true);
        
        $.ajax({
            url: '<?= SITE_URL ?>/admin/ajax/settings/update.php',
            type: 'POST',
            data: $(this).serialize(),
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'সফল!',
                        text: response.message,
                        timer: 2000,
                        showConfirmButton: false
                    });
                } else {
                    Swal.fire('ত্রুটি!', response.message, 'error');
                }
                btn.html(originalText).prop('disabled', false);
            },
            error: function(xhr) {
                Swal.fire('ত্রুটি!', 'সার্ভার সমস্যা: ' + xhr.responseText, 'error');
                btn.html(originalText).prop('disabled', false);
            }
        });
        
        return false;
    });
});
</script>
