<?php
/**
 * ============================================================
 * ADMIN: Users List
 * ============================================================
 */

$pageTitle = 'Users';

// Pagination
$page = max(1, (int)($_GET['p'] ?? 1));
$limit = 20;
$offset = ($page - 1) * $limit;

// Search
$search = sanitize($_GET['search'] ?? '');
$where = "1=1";
$params = [];

if ($search) {
    $where .= " AND (full_name LIKE ? OR email LIKE ? OR phone LIKE ?)";
    $searchParam = '%' . $search . '%';
    $params = [$searchParam, $searchParam, $searchParam];
}

$params[] = $limit;
$params[] = $offset;

$users = Database::fetchAll(
    "SELECT u.*, 
            (SELECT COUNT(*) FROM orders WHERE user_id = u.id) as order_count,
            (SELECT COALESCE(SUM(grand_total), 0) FROM orders WHERE user_id = u.id AND status = 'Delivered') as total_spent
     FROM users u
     WHERE {$where}
     ORDER BY u.created_at DESC
     LIMIT ? OFFSET ?",
    $params
);

include ADMIN_PATH . '/includes/header.php';
include ADMIN_PATH . '/includes/sidebar.php';
?>

<main class="admin-main">
    <?php include ADMIN_PATH . '/includes/topbar.php'; ?>
    
    <div class="admin-content">
        <h1 class="page-title">Users</h1>
        
        <!-- Search -->
        <div class="admin-form mb-4">
            <form method="GET" class="row g-3">
                <input type="hidden" name="page" value="users">
                <div class="col-md-4">
                    <input type="text" class="form-control" name="search" 
                           value="<?= sanitize($search) ?>" placeholder="Search name, email, phone...">
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-primary w-100">Search</button>
                </div>
            </form>
        </div>
        
        <div class="admin-table">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>User</th>
                            <th>Phone</th>
                            <th>Orders</th>
                            <th>Total Spent</th>
                            <th>Joined</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($users)): ?>
                        <tr>
                            <td colspan="7" class="text-center text-muted py-4">No users found</td>
                        </tr>
                        <?php else: ?>
                        <?php foreach ($users as $user): ?>
                        <tr>
                            <td>
                                <strong><?= sanitize($user['full_name']) ?></strong>
                                <small class="d-block text-muted"><?= sanitize($user['email']) ?></small>
                            </td>
                            <td><?= sanitize($user['phone']) ?></td>
                            <td><?= $user['order_count'] ?></td>
                            <td><?= formatPrice($user['total_spent']) ?></td>
                            <td><?= formatDate($user['created_at']) ?></td>
                            <td>
                                <?php if ($user['is_blocked']): ?>
                                <span class="badge bg-danger">Blocked</span>
                                <?php else: ?>
                                <span class="badge bg-success">Active</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if ($user['is_blocked']): ?>
                                <button type="button" class="btn btn-sm btn-outline-success btn-toggle-block"
                                        data-user-id="<?= $user['id'] ?>" data-action="unblock">
                                    <i class="bi bi-unlock me-1"></i> Unblock
                                </button>
                                <?php else: ?>
                                <button type="button" class="btn btn-sm btn-outline-danger btn-toggle-block"
                                        data-user-id="<?= $user['id'] ?>" data-action="block">
                                    <i class="bi bi-lock me-1"></i> Block
                                </button>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</main>

<div class="sidebar-overlay"></div>

<?php include ADMIN_PATH . '/includes/footer.php'; ?>
