<?php
/**
 * ============================================================
 * SAFA MODEST HOUSE - Main Configuration File
 * ============================================================
 * All site-wide constants and configuration settings
 */

// Prevent direct access
if (!defined('BASE_PATH')) {
    define('BASE_PATH', dirname(dirname(__DIR__)));
}

// ============================================================
// ENVIRONMENT SETTINGS
// ============================================================
define('APP_ENV', 'development'); // 'development' or 'production'
define('APP_DEBUG', APP_ENV === 'development');

// ============================================================
// SITE INFORMATION
// ============================================================
define('SITE_NAME', 'Safa Modest House');
define('SITE_TAGLINE', 'আপনার বিশ্বস্ত ফ্যাশন গন্তব্য');
define('SITE_URL', 'http://localhost/safa-modest-house');
define('ADMIN_URL', SITE_URL . '/admin');

// ============================================================
// DATABASE CONFIGURATION
// ============================================================
define('DB_HOST', 'localhost');
define('DB_NAME', 'safa_modest_house');
define('DB_USER', 'root');
define('DB_PASS', '');
define('DB_CHARSET', 'utf8mb4');

// ============================================================
// PATH CONFIGURATION
// ============================================================
define('APP_PATH', BASE_PATH . '/app');
define('PUBLIC_PATH', BASE_PATH . '/public');
define('ADMIN_PATH', BASE_PATH . '/admin');
define('STORAGE_PATH', BASE_PATH . '/storage');
define('UPLOAD_PATH', STORAGE_PATH . '/uploads');

// URL paths for assets
define('ASSETS_URL', SITE_URL . '/public/assets');
define('UPLOADS_URL', SITE_URL . '/storage/uploads');

// ============================================================
// SESSION CONFIGURATION
// ============================================================
define('SESSION_NAME', 'SAFA_SESS');
define('SESSION_LIFETIME', 7200); // 2 hours
define('SESSION_SECURE', false); // Set true in production with HTTPS
define('SESSION_HTTPONLY', true);

// ============================================================
// SECURITY SETTINGS
// ============================================================
define('CSRF_TOKEN_NAME', 'csrf_token');
define('PASSWORD_MIN_LENGTH', 8);
define('MAX_LOGIN_ATTEMPTS', 5);
define('LOGIN_LOCKOUT_TIME', 900); // 15 minutes

// ============================================================
// UPLOAD SETTINGS
// ============================================================
define('MAX_FILE_SIZE', 5 * 1024 * 1024); // 5MB
define('ALLOWED_IMAGE_TYPES', ['image/jpeg', 'image/png', 'image/gif', 'image/webp']);
define('ALLOWED_IMAGE_EXTENSIONS', ['jpg', 'jpeg', 'png', 'gif', 'webp']);
define('MAX_PRODUCT_IMAGES', 10);

// ============================================================
// BUSINESS SETTINGS (Bangladesh)
// ============================================================
define('CURRENCY_SYMBOL', '৳');
define('CURRENCY_CODE', 'BDT');
define('VAT_PERCENT', 15.00);
define('TAX_PERCENT', 0.00); // Additional tax if any
define('SHIPPING_COST_DHAKA', 60.00);
define('SHIPPING_COST_OUTSIDE', 120.00);

// bKash/Nagad Merchant Numbers (for display to customers)
define('BKASH_MERCHANT_NUMBER', '01712345678');
define('NAGAD_MERCHANT_NUMBER', '01812345678');

// WhatsApp Contact
define('WHATSAPP_NUMBER', '8801712345678');

// ============================================================
// PAGINATION
// ============================================================
define('PRODUCTS_PER_PAGE', 12);
define('ORDERS_PER_PAGE', 20);
define('REVIEWS_PER_PAGE', 10);

// ============================================================
// ERROR REPORTING
// ============================================================
if (APP_DEBUG) {
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
} else {
    error_reporting(0);
    ini_set('display_errors', 0);
}

// ============================================================
// TIMEZONE
// ============================================================
date_default_timezone_set('Asia/Dhaka');

// ============================================================
// AUTO-LOAD CORE FILES
// ============================================================
require_once APP_PATH . '/config/database.php';
require_once APP_PATH . '/core/helpers.php';
require_once APP_PATH . '/core/csrf.php';
require_once APP_PATH . '/core/response.php';
require_once APP_PATH . '/core/validator.php';
