<?php
/**
 * Footer Section
 */

// Load site settings if not already loaded
if (!isset($siteSettings)) {
    $siteSettings = [];
    try {
        $rows = Database::fetchAll("SELECT setting_key, setting_value FROM site_settings");
        foreach ($rows as $row) {
            $siteSettings[$row['setting_key']] = $row['setting_value'];
        }
    } catch (Exception $e) {}
}

if (!function_exists('setting')) {
    function setting($key, $default = '') {
        global $siteSettings;
        return $siteSettings[$key] ?? $default;
    }
}

$footerSiteName = setting('site_name', SITE_NAME);
$footerAbout = setting('footer_about', 'আমাদের কাছে পাবেন সেরা মানের পোশাক ও আনুষাঙ্গিক সামগ্রী।');
$footerAddress = setting('site_address', 'ঢাকা, বাংলাদেশ');
$footerPhone = setting('site_phone', '+880 1712-345678');
$footerEmail = setting('site_email', 'info@safamodesthouse.com');
$footerHours = setting('business_hours', 'সকাল ১০টা - রাত ১০টা');
$footerCopyright = setting('copyright_text', 'সর্বস্বত্ব সংরক্ষিত।');
$facebookUrl = setting('facebook_url', '#');
$instagramUrl = setting('instagram_url', '#');
$youtubeUrl = setting('youtube_url', '#');
$whatsappNum = setting('whatsapp_number', WHATSAPP_NUMBER);
?>

<!-- Footer -->
<footer class="bg-dark text-light pt-5 pb-3 mt-5">
    <div class="container">
        <div class="row g-4">
            <!-- About -->
            <div class="col-lg-4 col-md-6">
                <h5 class="fw-bold mb-3"><?= sanitize($footerSiteName) ?></h5>
                <p class="text-muted small">
                    <?= sanitize($footerAbout) ?>
                </p>
                <div class="d-flex gap-2 mt-3">
                    <?php if ($facebookUrl): ?>
                    <a href="<?= sanitize($facebookUrl) ?>" target="_blank" class="btn btn-outline-light btn-sm rounded-circle">
                        <i class="bi bi-facebook"></i>
                    </a>
                    <?php endif; ?>
                    <?php if ($instagramUrl): ?>
                    <a href="<?= sanitize($instagramUrl) ?>" target="_blank" class="btn btn-outline-light btn-sm rounded-circle">
                        <i class="bi bi-instagram"></i>
                    </a>
                    <?php endif; ?>
                    <?php if ($youtubeUrl): ?>
                    <a href="<?= sanitize($youtubeUrl) ?>" target="_blank" class="btn btn-outline-light btn-sm rounded-circle">
                        <i class="bi bi-youtube"></i>
                    </a>
                    <?php endif; ?>
                </div>
            </div>
            
            <!-- Quick Links -->
            <div class="col-lg-2 col-md-6">
                <h6 class="fw-bold mb-3">দ্রুত লিংক</h6>
                <ul class="list-unstyled small">
                    <li class="mb-2">
                        <a href="<?= url('public/?page=products') ?>" class="text-muted text-decoration-none">
                            সকল পণ্য
                        </a>
                    </li>
                    <li class="mb-2">
                        <a href="<?= url('public/?page=dashboard') ?>" class="text-muted text-decoration-none">
                            আমার অ্যাকাউন্ট
                        </a>
                    </li>
                    <li class="mb-2">
                        <a href="<?= url('public/?page=track-order') ?>" class="text-muted text-decoration-none">
                            অর্ডার ট্র্যাক
                        </a>
                    </li>
                    <li class="mb-2">
                        <a href="<?= url('public/?page=wishlist') ?>" class="text-muted text-decoration-none">
                            উইশলিস্ট
                        </a>
                    </li>
                </ul>
            </div>
            
            <!-- Customer Service -->
            <div class="col-lg-3 col-md-6">
                <h6 class="fw-bold mb-3">কাস্টমার সার্ভিস</h6>
                <ul class="list-unstyled small">
                    <li class="mb-2">
                        <a href="#" class="text-muted text-decoration-none">শিপিং পলিসি</a>
                    </li>
                    <li class="mb-2">
                        <a href="#" class="text-muted text-decoration-none">রিটার্ন ও রিফান্ড</a>
                    </li>
                    <li class="mb-2">
                        <a href="#" class="text-muted text-decoration-none">প্রাইভেসি পলিসি</a>
                    </li>
                    <li class="mb-2">
                        <a href="#" class="text-muted text-decoration-none">শর্তাবলী</a>
                    </li>
                </ul>
            </div>
            
            <!-- Contact -->
            <div class="col-lg-3 col-md-6">
                <h6 class="fw-bold mb-3">যোগাযোগ</h6>
                <ul class="list-unstyled small text-muted">
                    <li class="mb-2">
                        <i class="bi bi-geo-alt me-2"></i>
                        <?= sanitize($footerAddress) ?>
                    </li>
                    <li class="mb-2">
                        <i class="bi bi-telephone me-2"></i>
                        <?= sanitize($footerPhone) ?>
                    </li>
                    <li class="mb-2">
                        <i class="bi bi-envelope me-2"></i>
                        <?= sanitize($footerEmail) ?>
                    </li>
                    <li class="mb-2">
                        <i class="bi bi-clock me-2"></i>
                        <?= sanitize($footerHours) ?>
                    </li>
                </ul>
            </div>
        </div>
        
        <!-- Payment Methods -->
        <div class="row mt-4 pt-4 border-top border-secondary">
            <div class="col-md-6 text-center text-md-start mb-3 mb-md-0">
                <span class="text-muted small">পেমেন্ট মেথড:</span>
                <span class="badge bg-danger ms-2 px-2 py-1" style="font-size: 0.75rem;">bKash</span>
                <span class="badge bg-warning text-dark ms-2 px-2 py-1" style="font-size: 0.75rem;">Nagad</span>
            </div>
            <div class="col-md-6 text-center text-md-end">
                <small class="text-muted">
                    &copy; <?= date('Y') ?> <?= sanitize($footerSiteName) ?>। <?= sanitize($footerCopyright) ?>
                </small>
            </div>
        </div>
    </div>
</footer>

<!-- Floating WhatsApp Button -->
<a href="https://wa.me/<?= preg_replace('/[^0-9]/', '', $whatsappNum) ?>?text=হ্যালো! আমি আপনাদের ওয়েবসাইট থেকে এসেছি।" 
   target="_blank" 
   class="whatsapp-float"
   title="WhatsApp এ মেসেজ করুন">
    <i class="bi bi-whatsapp"></i>
</a>

<!-- jQuery -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

<!-- SweetAlert2 -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<!-- Global AJAX Handler -->
<script src="<?= asset('js/ajax-global.js') ?>"></script>

<!-- Main App JS -->
<script src="<?= asset('js/app.js') ?>"></script>

<?php if (isset($extraJs)): ?>
    <?= $extraJs ?>
<?php endif; ?>

</body>
</html>
