<?php
/**
 * Main Navigation Bar
 */

// Get cart count
require_once APP_PATH . '/services/cart_service.php';
$cartService = new CartService();
$cartCount = $cartService->getItemCount();

// Get categories for nav
$navCategories = Database::fetchAll(
    "SELECT id, name, slug FROM categories WHERE is_active = 1 ORDER BY sort_order LIMIT 6"
);

// Load site settings from database
$siteSettings = [];
try {
    $rows = Database::fetchAll("SELECT setting_key, setting_value FROM site_settings");
    foreach ($rows as $row) {
        $siteSettings[$row['setting_key']] = $row['setting_value'];
    }
} catch (Exception $e) {}

// Helper function
function setting($key, $default = '') {
    global $siteSettings;
    return $siteSettings[$key] ?? $default;
}

$sitePhone = setting('site_phone', '+880 1712-345678');
$siteEmail = setting('site_email', 'info@safamodesthouse.com');
$shippingDhaka = setting('shipping_dhaka', SHIPPING_COST_DHAKA);
$shippingOutside = setting('shipping_outside', SHIPPING_COST_OUTSIDE);
$siteName = setting('site_name', SITE_NAME);
?>

<!-- Top Bar -->
<div class="top-bar bg-primary text-white py-2 d-none d-md-block">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-md-6">
                <small>
                    <i class="bi bi-telephone me-1"></i> <?= sanitize($sitePhone) ?>
                    <span class="mx-2">|</span>
                    <i class="bi bi-envelope me-1"></i> <?= sanitize($siteEmail) ?>
                </small>
            </div>
            <div class="col-md-6 text-end">
                <small>
                    <i class="bi bi-truck me-1"></i> ঢাকায় ডেলিভারি ৳<?= $shippingDhaka ?> | ঢাকার বাইরে ৳<?= $shippingOutside ?>
                </small>
            </div>
        </div>
    </div>
</div>

<!-- Main Navbar -->
<nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm sticky-top">
    <div class="container">
        <!-- Logo -->
        <a class="navbar-brand" href="<?= url('public/') ?>">
            <img src="<?= asset('img/logo.png') ?>" alt="<?= SITE_NAME ?>" height="50" 
                 onerror="this.outerHTML='<span class=\'fw-bold text-primary fs-4\'><?= SITE_NAME ?></span>'">
        </a>
        
        <!-- Mobile Toggle -->
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#mainNav">
            <span class="navbar-toggler-icon"></span>
        </button>
        
        <!-- Nav Links -->
        <div class="collapse navbar-collapse" id="mainNav">
            <ul class="navbar-nav me-auto mb-2 mb-lg-0">
                <li class="nav-item">
                    <a class="nav-link" href="<?= url('public/') ?>">
                        <i class="bi bi-house-door me-1"></i> হোম
                    </a>
                </li>
                
                <!-- Categories Dropdown -->
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" data-bs-toggle="dropdown">
                        <i class="bi bi-grid me-1"></i> ক্যাটাগরি
                    </a>
                    <ul class="dropdown-menu">
                        <?php foreach ($navCategories as $cat): ?>
                        <li>
                            <a class="dropdown-item" href="<?= url('public/?page=products&category=' . $cat['slug']) ?>">
                                <?= sanitize($cat['name']) ?>
                            </a>
                        </li>
                        <?php endforeach; ?>
                        <li><hr class="dropdown-divider"></li>
                        <li>
                            <a class="dropdown-item" href="<?= url('public/?page=products') ?>">
                                <i class="bi bi-arrow-right me-1"></i> সকল পণ্য
                            </a>
                        </li>
                    </ul>
                </li>
                
                <li class="nav-item">
                    <a class="nav-link" href="<?= url('public/?page=products') ?>">
                        <i class="bi bi-bag me-1"></i> শপ
                    </a>
                </li>
            </ul>
            
            <!-- Search Form -->
            <form class="d-flex me-3 d-none d-lg-flex" action="<?= url('public/?page=products') ?>" method="GET">
                <input type="hidden" name="page" value="products">
                <div class="input-group">
                    <input type="text" class="form-control" name="search" placeholder="পণ্য খুঁজুন..." style="min-width: 200px;">
                    <button class="btn btn-outline-primary" type="submit">
                        <i class="bi bi-search"></i>
                    </button>
                </div>
            </form>
            
            <!-- Right Icons -->
            <ul class="navbar-nav">
                <?php if (isLoggedIn()): ?>
                    <!-- Wishlist -->
                    <li class="nav-item">
                        <a class="nav-link position-relative" href="<?= url('public/?page=wishlist') ?>" title="উইশলিস্ট">
                            <i class="bi bi-heart fs-5"></i>
                        </a>
                    </li>
                    
                    <!-- User Dropdown -->
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" data-bs-toggle="dropdown">
                            <i class="bi bi-person-circle fs-5"></i>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end">
                            <li>
                                <a class="dropdown-item" href="<?= url('public/?page=dashboard') ?>">
                                    <i class="bi bi-speedometer2 me-2"></i> ড্যাশবোর্ড
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item" href="<?= url('public/?page=dashboard&tab=orders') ?>">
                                    <i class="bi bi-box me-2"></i> আমার অর্ডার
                                </a>
                            </li>
                            <li><hr class="dropdown-divider"></li>
                            <li>
                                <a class="dropdown-item text-danger" href="#" id="logoutBtn">
                                    <i class="bi bi-box-arrow-right me-2"></i> লগআউট
                                </a>
                            </li>
                        </ul>
                    </li>
                <?php else: ?>
                    <li class="nav-item">
                        <a class="nav-link" href="<?= url('public/?page=login') ?>">
                            <i class="bi bi-person me-1"></i> লগইন
                        </a>
                    </li>
                <?php endif; ?>
                
                <!-- Cart -->
                <li class="nav-item">
                    <a class="nav-link position-relative" href="<?= url('public/?page=cart') ?>" title="কার্ট">
                        <i class="bi bi-cart3 fs-5"></i>
                        <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger cart-count" 
                              style="<?= $cartCount > 0 ? '' : 'display:none;' ?>">
                            <?= $cartCount ?>
                        </span>
                    </a>
                </li>
            </ul>
        </div>
    </div>
</nav>

<!-- Mobile Search (visible on small screens) -->
<div class="bg-light py-2 d-lg-none">
    <div class="container">
        <form action="<?= url('public/?page=products') ?>" method="GET">
            <input type="hidden" name="page" value="products">
            <div class="input-group">
                <input type="text" class="form-control" name="search" placeholder="পণ্য খুঁজুন...">
                <button class="btn btn-primary" type="submit">
                    <i class="bi bi-search"></i>
                </button>
            </div>
        </form>
    </div>
</div>
