<?php
/**
 * Product Card Component
 * Expects $product variable to be set
 */

$productUrl = url('public/?page=product&slug=' . $product['slug']);
$imageUrl = $product['primary_image'] 
    ? UPLOADS_URL . '/products/' . $product['primary_image'] 
    : asset('img/no-image.png');
$currentPrice = $product['sale_price'] ?? $product['price'];
$hasDiscount = $product['sale_price'] && $product['sale_price'] < $product['price'];

// Check if in wishlist
$inWishlist = false;
if (isLoggedIn()) {
    $inWishlist = Database::fetchColumn(
        "SELECT id FROM wishlists WHERE user_id = ? AND product_id = ?",
        [getUserId(), $product['id']]
    );
}
?>

<div class="product-card">
    <div class="product-image">
        <!-- Badges -->
        <?php if ($hasDiscount): ?>
        <div class="product-badge">
            <span class="badge bg-danger">
                -<?= round((($product['price'] - $product['sale_price']) / $product['price']) * 100) ?>%
            </span>
        </div>
        <?php endif; ?>
        
        <!-- Wishlist Button -->
        <div class="product-actions">
            <button type="button" class="btn btn-sm btn-light rounded-circle btn-wishlist" 
                    data-product-id="<?= $product['id'] ?>" title="উইশলিস্টে যোগ করুন">
                <i class="bi bi-heart<?= $inWishlist ? '-fill text-danger' : '' ?>"></i>
            </button>
        </div>
        
        <a href="<?= $productUrl ?>">
            <img src="<?= $imageUrl ?>" alt="<?= sanitize($product['name']) ?>" loading="lazy">
        </a>
    </div>
    
    <div class="product-info">
        <h3 class="product-title">
            <a href="<?= $productUrl ?>"><?= sanitize($product['name']) ?></a>
        </h3>
        
        <!-- Rating -->
        <?php if ($product['review_count'] > 0): ?>
        <div class="product-rating mb-1">
            <?php for ($i = 1; $i <= 5; $i++): ?>
            <i class="bi bi-star<?= $i <= round($product['avg_rating']) ? '-fill' : '' ?>"></i>
            <?php endfor; ?>
            <small class="text-muted">(<?= $product['review_count'] ?>)</small>
        </div>
        <?php endif; ?>
        
        <!-- Price -->
        <div class="product-price">
            <?= formatPrice($currentPrice) ?>
            <?php if ($hasDiscount): ?>
            <span class="original-price"><?= formatPrice($product['price']) ?></span>
            <?php endif; ?>
        </div>
        
        <!-- Add to Cart -->
        <div class="product-actions-form mt-2">
            <input type="hidden" class="qty-input" value="1">
            <?php if ($product['stock_qty'] > 0): ?>
            <button type="button" class="btn btn-primary btn-sm w-100 btn-add-cart" 
                    data-product-id="<?= $product['id'] ?>">
                <i class="bi bi-cart-plus me-1"></i> কার্টে যোগ করুন
            </button>
            <?php else: ?>
            <button type="button" class="btn btn-secondary btn-sm w-100" disabled>
                <i class="bi bi-x-circle me-1"></i> স্টক শেষ
            </button>
            <?php endif; ?>
        </div>
    </div>
</div>
