<?php
/**
 * ============================================================
 * SAFA MODEST HOUSE - Main Entry Point
 * ============================================================
 * All public pages route through here
 */

// Initialize application
define('BASE_PATH', dirname(__DIR__));
require_once BASE_PATH . '/app/config/config.php';

// Start session
if (session_status() === PHP_SESSION_NONE) {
    session_name(SESSION_NAME);
    session_set_cookie_params([
        'lifetime' => SESSION_LIFETIME,
        'path' => '/',
        'secure' => SESSION_SECURE,
        'httponly' => SESSION_HTTPONLY,
        'samesite' => 'Lax'
    ]);
    session_start();
}

// Generate CSRF token
CSRF::generateToken();

// Simple router
$page = isset($_GET['page']) ? sanitize($_GET['page']) : 'home';

// Valid pages
$validPages = [
    'home', 'products', 'product', 'cart', 'checkout', 
    'order-success', 'login', 'register', 'dashboard',
    'wishlist', 'track-order'
];

if (!in_array($page, $validPages)) {
    $page = 'home';
}

// Page file path
$pageFile = PUBLIC_PATH . '/pages/' . $page . '.php';

if (!file_exists($pageFile)) {
    $pageFile = PUBLIC_PATH . '/pages/home.php';
}

// Include the page
require_once $pageFile;
