<?php
/**
 * ============================================================
 * CART PAGE
 * ============================================================
 */

require_once APP_PATH . '/services/cart_service.php';

$cartService = new CartService();
$cartItems = $cartService->getItems();
$cartTotals = $cartService->getTotals();

// Page meta
$pageTitle = 'কার্ট';
$pageDescription = 'আপনার শপিং কার্ট';

include PUBLIC_PATH . '/includes/head.php';
include PUBLIC_PATH . '/includes/navbar.php';
?>

<main class="py-4">
    <div class="container">
        <!-- Breadcrumb -->
        <nav aria-label="breadcrumb" class="mb-4">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?= url('public/') ?>">হোম</a></li>
                <li class="breadcrumb-item active">কার্ট</li>
            </ol>
        </nav>
        
        <h2 class="mb-4"><i class="bi bi-cart3 me-2"></i>শপিং কার্ট</h2>
        
        <?php if (empty($cartItems)): ?>
        <!-- Empty Cart -->
        <div class="text-center py-5 bg-white rounded shadow-sm">
            <i class="bi bi-cart-x display-1 text-muted"></i>
            <h4 class="mt-3">আপনার কার্ট খালি</h4>
            <p class="text-muted">এখনই কেনাকাটা শুরু করুন!</p>
            <a href="<?= url('public/?page=products') ?>" class="btn btn-primary btn-lg">
                <i class="bi bi-bag me-2"></i>শপ করুন
            </a>
        </div>
        <?php else: ?>
        
        <div class="row g-4">
            <!-- Cart Items -->
            <div class="col-lg-8">
                <?php foreach ($cartItems as $item): ?>
                <div class="cart-item shadow-sm" data-unit-price="<?= $item['unit_price'] ?>">
                    <div class="row align-items-center">
                        <!-- Image -->
                        <div class="col-3 col-md-2">
                            <img src="<?= $item['image'] ? UPLOADS_URL . '/products/' . $item['image'] : asset('img/no-image.png') ?>" 
                                 alt="<?= sanitize($item['name']) ?>" class="cart-item-image">
                        </div>
                        
                        <!-- Info -->
                        <div class="col-9 col-md-4">
                            <h6 class="mb-1">
                                <a href="<?= url('public/?page=product&id=' . $item['product_id']) ?>" class="text-dark text-decoration-none">
                                    <?= sanitize($item['name']) ?>
                                </a>
                            </h6>
                            <p class="text-muted mb-0 small"><?= formatPrice($item['unit_price']) ?></p>
                        </div>
                        
                        <!-- Quantity -->
                        <div class="col-6 col-md-3 mt-3 mt-md-0">
                            <div class="input-group qty-input-group">
                                <button type="button" class="btn btn-outline-secondary btn-qty-update" data-action="decrease">
                                    <i class="bi bi-dash"></i>
                                </button>
                                <input type="number" class="form-control cart-qty-input" 
                                       value="<?= $item['qty'] ?>" min="1" max="<?= $item['stock_qty'] ?>"
                                       data-product-id="<?= $item['product_id'] ?>">
                                <button type="button" class="btn btn-outline-secondary btn-qty-update" data-action="increase">
                                    <i class="bi bi-plus"></i>
                                </button>
                            </div>
                        </div>
                        
                        <!-- Subtotal & Remove -->
                        <div class="col-6 col-md-3 mt-3 mt-md-0 text-end">
                            <p class="fw-bold mb-1 line-total"><?= formatPrice($item['qty'] * $item['unit_price']) ?></p>
                            <button type="button" class="btn btn-sm btn-outline-danger btn-remove-cart" 
                                    data-product-id="<?= $item['product_id'] ?>">
                                <i class="bi bi-trash"></i> সরান
                            </button>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
                
                <!-- Continue Shopping -->
                <div class="mt-4">
                    <a href="<?= url('public/?page=products') ?>" class="btn btn-outline-primary">
                        <i class="bi bi-arrow-left me-2"></i>আরো কেনাকাটা করুন
                    </a>
                </div>
            </div>
            
            <!-- Order Summary -->
            <div class="col-lg-4">
                <div class="order-summary">
                    <h5 class="mb-3"><i class="bi bi-receipt me-2"></i>অর্ডার সামারি</h5>
                    
                    <div class="summary-row">
                        <span>সাবটোটাল</span>
                        <span id="cart-subtotal"><?= formatPrice($cartTotals['subtotal']) ?></span>
                    </div>
                    
                    <div class="summary-row">
                        <span>ভ্যাট (<?= VAT_PERCENT ?>%)</span>
                        <span id="cart-vat"><?= formatPrice($cartTotals['vat_amount']) ?></span>
                    </div>
                    
                    <?php if ($cartTotals['tax_amount'] > 0): ?>
                    <div class="summary-row">
                        <span>ট্যাক্স</span>
                        <span id="cart-tax"><?= formatPrice($cartTotals['tax_amount']) ?></span>
                    </div>
                    <?php endif; ?>
                    
                    <div class="summary-row text-success">
                        <span>ছাড়</span>
                        <span id="cart-discount">- <?= formatPrice(0) ?></span>
                    </div>
                    
                    <div class="summary-row total">
                        <span>সর্বমোট</span>
                        <span id="cart-grand-total"><?= formatPrice($cartTotals['grand_total']) ?></span>
                    </div>
                    
                    <?php if (isLoggedIn()): ?>
                    <a href="<?= url('public/?page=checkout') ?>" class="btn btn-primary btn-lg w-100 mt-3">
                        <i class="bi bi-credit-card me-2"></i>চেকআউট করুন
                    </a>
                    <?php else: ?>
                    <a href="<?= url('public/?page=login') ?>" class="btn btn-primary btn-lg w-100 mt-3">
                        <i class="bi bi-box-arrow-in-right me-2"></i>চেকআউটের জন্য লগইন করুন
                    </a>
                    <p class="text-center text-muted small mt-2">
                        নতুন? <a href="<?= url('public/?page=register') ?>">রেজিস্ট্রেশন করুন</a>
                    </p>
                    <?php endif; ?>
                    
                    <p class="text-muted small text-center mt-3 mb-0">
                        <i class="bi bi-shield-check me-1"></i>
                        নিরাপদ চেকআউট
                    </p>
                </div>
            </div>
        </div>
        
        <?php endif; ?>
    </div>
</main>

<?php include PUBLIC_PATH . '/includes/footer.php'; ?>
