<?php
/**
 * ============================================================
 * USER DASHBOARD
 * ============================================================
 */

require_once APP_PATH . '/middleware/require_user.php';
require_once APP_PATH . '/services/order_service.php';

$userId = getUserId();
$user = Database::fetchOne("SELECT * FROM users WHERE id = ?", [$userId]);

// Get user orders
$orders = OrderService::getByUser($userId, 20, 0);

// Get wishlist count
$wishlistCount = Database::fetchColumn(
    "SELECT COUNT(*) FROM wishlists WHERE user_id = ?", [$userId]
);

// Current tab
$tab = sanitize($_GET['tab'] ?? 'overview');

$pageTitle = 'আমার অ্যাকাউন্ট';
$pageDescription = 'আপনার অ্যাকাউন্ট ড্যাশবোর্ড';

include PUBLIC_PATH . '/includes/head.php';
include PUBLIC_PATH . '/includes/navbar.php';
?>

<main class="py-4">
    <div class="container">
        <h2 class="mb-4"><i class="bi bi-person-circle me-2"></i>আমার অ্যাকাউন্ট</h2>
        
        <div class="row g-4">
            <!-- Sidebar -->
            <div class="col-lg-3">
                <div class="dashboard-sidebar">
                    <a href="<?= url('public/?page=dashboard') ?>" 
                       class="nav-link <?= $tab === 'overview' ? 'active' : '' ?>">
                        <i class="bi bi-speedometer2 me-2"></i>ওভারভিউ
                    </a>
                    <a href="<?= url('public/?page=dashboard&tab=orders') ?>" 
                       class="nav-link <?= $tab === 'orders' ? 'active' : '' ?>">
                        <i class="bi bi-bag me-2"></i>আমার অর্ডার
                    </a>
                    <a href="<?= url('public/?page=wishlist') ?>" class="nav-link">
                        <i class="bi bi-heart me-2"></i>উইশলিস্ট
                        <?php if ($wishlistCount > 0): ?>
                        <span class="badge bg-primary"><?= $wishlistCount ?></span>
                        <?php endif; ?>
                    </a>
                    <a href="<?= url('public/?page=dashboard&tab=profile') ?>" 
                       class="nav-link <?= $tab === 'profile' ? 'active' : '' ?>">
                        <i class="bi bi-person me-2"></i>প্রোফাইল
                    </a>
                    <a href="#" class="nav-link text-danger" id="logoutBtn">
                        <i class="bi bi-box-arrow-right me-2"></i>লগআউট
                    </a>
                </div>
            </div>
            
            <!-- Content -->
            <div class="col-lg-9">
                <div class="dashboard-content">
                    <?php if ($tab === 'overview'): ?>
                    <!-- Overview -->
                    <h4 class="mb-4">স্বাগতম, <?= sanitize($user['full_name']) ?>!</h4>
                    
                    <div class="row g-3 mb-4">
                        <div class="col-md-4">
                            <div class="border rounded p-3 text-center">
                                <h3 class="text-primary mb-1"><?= count($orders) ?></h3>
                                <small class="text-muted">মোট অর্ডার</small>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="border rounded p-3 text-center">
                                <h3 class="text-success mb-1">
                                    <?= count(array_filter($orders, fn($o) => $o['status'] === 'Delivered')) ?>
                                </h3>
                                <small class="text-muted">সম্পন্ন</small>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="border rounded p-3 text-center">
                                <h3 class="text-warning mb-1"><?= $wishlistCount ?></h3>
                                <small class="text-muted">উইশলিস্ট</small>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Recent Orders -->
                    <h5 class="mb-3">সাম্প্রতিক অর্ডার</h5>
                    <?php $recentOrders = array_slice($orders, 0, 5); ?>
                    <?php if (empty($recentOrders)): ?>
                    <p class="text-muted">কোনো অর্ডার নেই।</p>
                    <?php else: ?>
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr><th>অর্ডার নং</th><th>তারিখ</th><th>মোট</th><th>স্ট্যাটাস</th></tr>
                            </thead>
                            <tbody>
                                <?php foreach ($recentOrders as $order): ?>
                                <tr>
                                    <td><a href="<?= url('public/?page=track-order&order=' . $order['order_no']) ?>"><?= $order['order_no'] ?></a></td>
                                    <td><?= formatDate($order['created_at']) ?></td>
                                    <td><?= formatPrice($order['grand_total']) ?></td>
                                    <td><span class="badge <?= getOrderStatusBadge($order['status']) ?>"><?= $order['status'] ?></span></td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    <?php endif; ?>
                    
                    <?php elseif ($tab === 'orders'): ?>
                    <!-- Orders List -->
                    <h4 class="mb-4">আমার অর্ডার</h4>
                    <?php if (empty($orders)): ?>
                    <p class="text-muted">কোনো অর্ডার নেই।</p>
                    <?php else: ?>
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr><th>অর্ডার নং</th><th>তারিখ</th><th>আইটেম</th><th>মোট</th><th>স্ট্যাটাস</th><th></th></tr>
                            </thead>
                            <tbody>
                                <?php foreach ($orders as $order): ?>
                                <tr>
                                    <td><strong><?= $order['order_no'] ?></strong></td>
                                    <td><?= formatDate($order['created_at']) ?></td>
                                    <td><?= Database::fetchColumn("SELECT SUM(qty) FROM order_items WHERE order_id = ?", [$order['id']]) ?></td>
                                    <td><?= formatPrice($order['grand_total']) ?></td>
                                    <td><span class="badge <?= getOrderStatusBadge($order['status']) ?>"><?= $order['status'] ?></span></td>
                                    <td><a href="<?= url('public/?page=track-order&order=' . $order['order_no']) ?>" class="btn btn-sm btn-outline-primary">বিস্তারিত</a></td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    <?php endif; ?>
                    
                    <?php elseif ($tab === 'profile'): ?>
                    <!-- Profile -->
                    <h4 class="mb-4">প্রোফাইল তথ্য</h4>
                    <div class="row">
                        <div class="col-md-6">
                            <p><strong>নাম:</strong> <?= sanitize($user['full_name']) ?></p>
                            <p><strong>ইমেইল:</strong> <?= sanitize($user['email']) ?></p>
                            <p><strong>ফোন:</strong> <?= sanitize($user['phone']) ?></p>
                            <p><strong>সদস্য হয়েছেন:</strong> <?= formatDate($user['created_at']) ?></p>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</main>

<?php include PUBLIC_PATH . '/includes/footer.php'; ?>
