<?php
/**
 * ============================================================
 * HOME PAGE
 * ============================================================
 * Hero banner, featured products, categories, best sellers
 */

require_once APP_PATH . '/services/product_service.php';

// Get featured products
$featuredProducts = ProductService::getFeatured(8);

// Get best sellers
$bestSellers = ProductService::getBestSellers(8);

// Get categories
$categories = Database::fetchAll(
    "SELECT * FROM categories WHERE is_active = 1 ORDER BY sort_order LIMIT 6"
);

// Page meta
$pageTitle = 'হোম';
$pageDescription = SITE_TAGLINE;

include PUBLIC_PATH . '/includes/head.php';
include PUBLIC_PATH . '/includes/navbar.php';
?>

<main>
    <!-- Hero Section -->
    <section class="hero-section">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <h1 class="display-5 fw-bold mb-3"><?= SITE_NAME ?></h1>
                    <p class="lead mb-4"><?= SITE_TAGLINE ?>। সেরা মানের পোশাক, সাশ্রয়ী মূল্যে।</p>
                    <div class="d-flex gap-3 flex-wrap">
                        <a href="<?= url('public/?page=products') ?>" class="btn btn-light btn-lg">
                            <i class="bi bi-bag me-2"></i>শপ করুন
                        </a>
                        <a href="<?= url('public/?page=products&featured=1') ?>" class="btn btn-outline-light btn-lg">
                            ফিচার্ড পণ্য
                        </a>
                    </div>
                </div>
                <div class="col-lg-6 d-none d-lg-block text-center">
                    <img src="<?= asset('img/hero-fashion.png') ?>" alt="Fashion" class="img-fluid" 
                         style="max-height: 400px;" onerror="this.style.display='none'">
                </div>
            </div>
        </div>
    </section>
    
    <!-- Features Bar -->
    <section class="py-4 bg-white border-bottom">
        <div class="container">
            <div class="row text-center g-4">
                <div class="col-6 col-md-3">
                    <i class="bi bi-truck fs-2 text-primary"></i>
                    <h6 class="mt-2 mb-1">দ্রুত ডেলিভারি</h6>
                    <small class="text-muted">সারা বাংলাদেশে</small>
                </div>
                <div class="col-6 col-md-3">
                    <i class="bi bi-shield-check fs-2 text-primary"></i>
                    <h6 class="mt-2 mb-1">নিরাপদ পেমেন্ট</h6>
                    <small class="text-muted">bKash / Nagad</small>
                </div>
                <div class="col-6 col-md-3">
                    <i class="bi bi-arrow-repeat fs-2 text-primary"></i>
                    <h6 class="mt-2 mb-1">সহজ রিটার্ন</h6>
                    <small class="text-muted">৭ দিনের মধ্যে</small>
                </div>
                <div class="col-6 col-md-3">
                    <i class="bi bi-headset fs-2 text-primary"></i>
                    <h6 class="mt-2 mb-1">২৪/৭ সাপোর্ট</h6>
                    <small class="text-muted">WhatsApp এ যোগাযোগ</small>
                </div>
            </div>
        </div>
    </section>
    
    <!-- Categories Section -->
    <?php if (!empty($categories)): ?>
    <section class="py-5">
        <div class="container">
            <h2 class="section-title">ক্যাটাগরি</h2>
            
            <div class="row g-4">
                <?php foreach ($categories as $cat): ?>
                <div class="col-6 col-md-4 col-lg-2">
                    <a href="<?= url('public/?page=products&category=' . $cat['slug']) ?>" class="text-decoration-none">
                        <div class="category-card">
                            <?php if ($cat['image']): ?>
                            <img src="<?= UPLOADS_URL . '/categories/' . $cat['image'] ?>" alt="<?= sanitize($cat['name']) ?>">
                            <?php else: ?>
                            <div class="bg-gradient-primary w-100 h-100"></div>
                            <?php endif; ?>
                            <div class="category-overlay">
                                <span class="category-name"><?= sanitize($cat['name']) ?></span>
                            </div>
                        </div>
                    </a>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
    </section>
    <?php endif; ?>
    
    <!-- Featured Products -->
    <?php if (!empty($featuredProducts)): ?>
    <section class="py-5 bg-light">
        <div class="container">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h2 class="section-title mb-0">ফিচার্ড পণ্য</h2>
                <a href="<?= url('public/?page=products&featured=1') ?>" class="btn btn-outline-primary">
                    সব দেখুন <i class="bi bi-arrow-right ms-1"></i>
                </a>
            </div>
            
            <div class="row g-4">
                <?php foreach ($featuredProducts as $product): ?>
                <div class="col-6 col-md-4 col-lg-3">
                    <?php include PUBLIC_PATH . '/includes/product-card.php'; ?>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
    </section>
    <?php endif; ?>
    
    <!-- Best Sellers -->
    <?php if (!empty($bestSellers)): ?>
    <section class="py-5">
        <div class="container">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h2 class="section-title mb-0">বেস্ট সেলার</h2>
                <a href="<?= url('public/?page=products&sort=popular') ?>" class="btn btn-outline-primary">
                    সব দেখুন <i class="bi bi-arrow-right ms-1"></i>
                </a>
            </div>
            
            <div class="row g-4">
                <?php foreach ($bestSellers as $product): ?>
                <div class="col-6 col-md-4 col-lg-3">
                    <?php include PUBLIC_PATH . '/includes/product-card.php'; ?>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
    </section>
    <?php endif; ?>
    
    <!-- Newsletter / CTA -->
    <section class="py-5 bg-primary text-white">
        <div class="container text-center">
            <h3 class="mb-3">নতুন অফার ও আপডেট পেতে</h3>
            <p class="mb-4">আমাদের WhatsApp এ যোগ দিন এবং এক্সক্লুসিভ ডিল পান!</p>
            <a href="https://wa.me/<?= WHATSAPP_NUMBER ?>" target="_blank" class="btn btn-light btn-lg">
                <i class="bi bi-whatsapp me-2"></i>WhatsApp এ যোগ দিন
            </a>
        </div>
    </section>
</main>

<?php include PUBLIC_PATH . '/includes/footer.php'; ?>
