<?php
/**
 * ============================================================
 * LOGIN PAGE
 * ============================================================
 */

// Redirect if already logged in
if (isLoggedIn()) {
    redirect(url('public/?page=dashboard'));
}

$pageTitle = 'লগইন';
$pageDescription = 'আপনার অ্যাকাউন্টে লগইন করুন';

include PUBLIC_PATH . '/includes/head.php';
include PUBLIC_PATH . '/includes/navbar.php';
?>

<main class="py-5">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-6 col-lg-5">
                <div class="bg-white rounded shadow-sm p-4 p-md-5">
                    <div class="text-center mb-4">
                        <i class="bi bi-person-circle display-4 text-primary"></i>
                        <h2 class="mt-2">লগইন</h2>
                        <p class="text-muted">আপনার অ্যাকাউন্টে প্রবেশ করুন</p>
                    </div>
                    
                    <form id="loginForm">
                        <?= csrf_field() ?>
                        
                        <div class="mb-3">
                            <label for="email" class="form-label">ইমেইল <span class="text-danger">*</span></label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="bi bi-envelope"></i></span>
                                <input type="email" class="form-control" id="email" name="email" 
                                       placeholder="your@email.com" required autofocus>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label for="password" class="form-label">পাসওয়ার্ড <span class="text-danger">*</span></label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="bi bi-key"></i></span>
                                <input type="password" class="form-control" id="password" name="password" 
                                       placeholder="আপনার পাসওয়ার্ড" required>
                            </div>
                        </div>
                        
                        <div class="d-flex justify-content-between align-items-center mb-4">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="remember" name="remember">
                                <label class="form-check-label" for="remember">মনে রাখুন</label>
                            </div>
                            <a href="#" class="text-decoration-none small">পাসওয়ার্ড ভুলে গেছেন?</a>
                        </div>
                        
                        <button type="submit" class="btn btn-primary btn-lg w-100">
                            <i class="bi bi-box-arrow-in-right me-2"></i>লগইন করুন
                        </button>
                    </form>
                    
                    <hr class="my-4">
                    
                    <p class="text-center mb-0">
                        নতুন কাস্টমার? 
                        <a href="<?= url('public/?page=register') ?>" class="text-decoration-none fw-bold">
                            রেজিস্ট্রেশন করুন
                        </a>
                    </p>
                </div>
            </div>
        </div>
    </div>
</main>

<?php include PUBLIC_PATH . '/includes/footer.php'; ?>

<script>
$(function() {
    var loginUrl = '<?= SITE_URL ?>/public/ajax/auth/login.php';
    var dashboardUrl = '<?= SITE_URL ?>/public/?page=dashboard';
    
    $('#loginForm').on('submit', function(e) {
        e.preventDefault();
        
        var form = $(this);
        var btn = form.find('button[type="submit"]');
        var originalText = btn.html();
        
        btn.html('<span class="spinner-border spinner-border-sm me-2"></span>অপেক্ষা করুন...').prop('disabled', true);
        
        $.ajax({
            url: loginUrl,
            type: 'POST',
            data: form.serialize(),
            dataType: 'json'
        }).done(function(response) {
            if (response.success) {
                Swal.fire({
                    icon: 'success',
                    title: 'সফল!',
                    text: response.message,
                    timer: 1500,
                    showConfirmButton: false
                }).then(function() {
                    window.location.href = response.data.redirect || dashboardUrl;
                });
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'ত্রুটি!',
                    text: response.message || 'লগইন ব্যর্থ হয়েছে'
                });
            }
        }).fail(function(xhr) {
            console.log('Error:', xhr.responseText);
            Swal.fire({
                icon: 'error',
                title: 'ত্রুটি!',
                text: 'সার্ভার সমস্যা। আবার চেষ্টা করুন।'
            });
        }).always(function() {
            btn.html(originalText).prop('disabled', false);
        });
        
        return false;
    });
});
</script>
