<?php
/**
 * ============================================================
 * ORDER SUCCESS PAGE
 * ============================================================
 */

require_once APP_PATH . '/middleware/require_user.php';

$orderNo = sanitize($_GET['order'] ?? '');

if (!$orderNo) {
    redirect(url('public/'));
}

// Verify order belongs to user
$order = Database::fetchOne(
    "SELECT * FROM orders WHERE order_no = ? AND user_id = ?",
    [$orderNo, getUserId()]
);

if (!$order) {
    redirect(url('public/'));
}

$pageTitle = 'অর্ডার সফল!';

include PUBLIC_PATH . '/includes/head.php';
include PUBLIC_PATH . '/includes/navbar.php';
?>

<main class="py-5">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-8 col-lg-6 text-center">
                <div class="bg-white rounded shadow-sm p-5">
                    <div class="mb-4">
                        <i class="bi bi-check-circle-fill text-success" style="font-size: 5rem;"></i>
                    </div>
                    
                    <h2 class="mb-3">অর্ডার সফলভাবে সম্পন্ন!</h2>
                    <p class="text-muted mb-4">
                        আপনার অর্ডার গ্রহণ করা হয়েছে। আমরা শীঘ্রই আপনার সাথে যোগাযোগ করব।
                    </p>
                    
                    <div class="bg-light rounded p-4 mb-4">
                        <h5 class="mb-3">অর্ডার তথ্য</h5>
                        <p class="mb-2">
                            <strong>অর্ডার নম্বর:</strong> 
                            <span class="text-primary"><?= sanitize($order['order_no']) ?></span>
                        </p>
                        <p class="mb-2">
                            <strong>মোট টাকা:</strong> 
                            <span class="text-primary"><?= formatPrice($order['grand_total']) ?></span>
                        </p>
                        <p class="mb-0">
                            <strong>পেমেন্ট মেথড:</strong> 
                            <?= sanitize($order['payment_method']) ?>
                        </p>
                    </div>
                    
                    <div class="alert alert-info text-start">
                        <h6><i class="bi bi-info-circle me-2"></i>পরবর্তী ধাপ</h6>
                        <ul class="mb-0 ps-3">
                            <li>আপনার পেমেন্ট যাচাই করা হবে</li>
                            <li>অর্ডার কনফার্ম হলে আপনাকে জানানো হবে</li>
                            <li>পণ্য প্রস্তুত হলে ডেলিভারি শুরু হবে</li>
                        </ul>
                    </div>
                    
                    <div class="d-flex gap-3 justify-content-center flex-wrap">
                        <a href="<?= url('public/?page=track-order&order=' . $order['order_no']) ?>" 
                           class="btn btn-primary">
                            <i class="bi bi-geo-alt me-2"></i>অর্ডার ট্র্যাক করুন
                        </a>
                        <a href="<?= url('public/?page=products') ?>" class="btn btn-outline-secondary">
                            <i class="bi bi-bag me-2"></i>আরো কেনাকাটা
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<?php include PUBLIC_PATH . '/includes/footer.php'; ?>
