<?php
/**
 * ============================================================
 * REGISTRATION PAGE
 * ============================================================
 */

// Redirect if already logged in
if (isLoggedIn()) {
    redirect(url('public/?page=dashboard'));
}

$pageTitle = 'রেজিস্ট্রেশন';
$pageDescription = 'নতুন অ্যাকাউন্ট তৈরি করুন';

include PUBLIC_PATH . '/includes/head.php';
include PUBLIC_PATH . '/includes/navbar.php';
?>

<main class="py-5">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-8 col-lg-6">
                <div class="bg-white rounded shadow-sm p-4 p-md-5">
                    <div class="text-center mb-4">
                        <i class="bi bi-person-plus display-4 text-primary"></i>
                        <h2 class="mt-2">রেজিস্ট্রেশন</h2>
                        <p class="text-muted">নতুন অ্যাকাউন্ট তৈরি করুন</p>
                    </div>
                    
                    <form id="registerForm" onsubmit="return false;">
                        <?= csrf_field() ?>
                        
                        <div class="mb-3">
                            <label for="full_name" class="form-label">পুরো নাম <span class="text-danger">*</span></label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="bi bi-person"></i></span>
                                <input type="text" class="form-control" id="full_name" name="full_name" 
                                       placeholder="আপনার পুরো নাম" required>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label for="email" class="form-label">ইমেইল <span class="text-danger">*</span></label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="bi bi-envelope"></i></span>
                                <input type="email" class="form-control" id="email" name="email" 
                                       placeholder="your@email.com" required>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label for="phone" class="form-label">মোবাইল নম্বর <span class="text-danger">*</span></label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="bi bi-phone"></i></span>
                                <input type="tel" class="form-control" id="phone" name="phone" 
                                       placeholder="01XXXXXXXXX" required>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="password" class="form-label">পাসওয়ার্ড <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="bi bi-key"></i></span>
                                    <input type="password" class="form-control" id="password" name="password" 
                                           placeholder="কমপক্ষে ৮ অক্ষর" required minlength="<?= PASSWORD_MIN_LENGTH ?>">
                                </div>
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label for="password_confirmation" class="form-label">পাসওয়ার্ড নিশ্চিত করুন <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="bi bi-key-fill"></i></span>
                                    <input type="password" class="form-control" id="password_confirmation" name="password_confirmation" 
                                           placeholder="পুনরায় পাসওয়ার্ড দিন" required>
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-check mb-4">
                            <input class="form-check-input" type="checkbox" id="agree_terms" required>
                            <label class="form-check-label" for="agree_terms">
                                আমি <a href="#" class="text-decoration-none">শর্তাবলী</a> ও 
                                <a href="#" class="text-decoration-none">প্রাইভেসি পলিসি</a> মেনে নিচ্ছি
                            </label>
                        </div>
                        
                        <button type="submit" class="btn btn-primary btn-lg w-100">
                            <i class="bi bi-person-plus me-2"></i>রেজিস্ট্রেশন করুন
                        </button>
                    </form>
                    
                    <hr class="my-4">
                    
                    <p class="text-center mb-0">
                        ইতিমধ্যে অ্যাকাউন্ট আছে? 
                        <a href="<?= url('public/?page=login') ?>" class="text-decoration-none fw-bold">
                            লগইন করুন
                        </a>
                    </p>
                </div>
            </div>
        </div>
    </div>
</main>

<?php include PUBLIC_PATH . '/includes/footer.php'; ?>

<script>
$(function() {
    $('#registerForm').on('submit', function(e) {
        e.preventDefault();
        
        var form = $(this);
        var btn = form.find('button[type="submit"]');
        var originalText = btn.html();
        
        btn.html('<span class="spinner-border spinner-border-sm me-2"></span>অপেক্ষা করুন...').prop('disabled', true);
        form.find('.is-invalid').removeClass('is-invalid');
        form.find('.invalid-feedback').remove();
        
        $.post('<?= SITE_URL ?>/public/ajax/auth/register.php', form.serialize(), function(response) {
            if (response.success) {
                Swal.fire({
                    icon: 'success',
                    title: 'সফল!',
                    text: response.message,
                    timer: 2000,
                    showConfirmButton: false
                }).then(function() {
                    window.location.href = '<?= SITE_URL ?>/public/?page=login';
                });
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'ত্রুটি!',
                    text: response.message
                });
                if (response.errors) {
                    $.each(response.errors, function(field, msg) {
                        form.find('[name="' + field + '"]').addClass('is-invalid')
                            .after('<div class="invalid-feedback d-block">' + msg + '</div>');
                    });
                }
            }
            btn.html(originalText).prop('disabled', false);
        }, 'json').fail(function(xhr) {
            console.log('Error:', xhr.responseText);
            Swal.fire('ত্রুটি!', 'সার্ভার সমস্যা: ' + xhr.responseText, 'error');
            btn.html(originalText).prop('disabled', false);
        });
        
        return false;
    });
});
</script>
