<?php
/**
 * ============================================================
 * WISHLIST PAGE
 * ============================================================
 */

require_once APP_PATH . '/middleware/require_user.php';

$userId = getUserId();

// Get wishlist items
$wishlistItems = Database::fetchAll(
    "SELECT w.id, w.created_at as added_at, p.*, 
            (SELECT file_path FROM product_images WHERE product_id = p.id AND is_primary = 1 LIMIT 1) as primary_image
     FROM wishlists w
     JOIN products p ON w.product_id = p.id
     WHERE w.user_id = ? AND p.is_active = 1
     ORDER BY w.created_at DESC",
    [$userId]
);

$pageTitle = 'উইশলিস্ট';
$pageDescription = 'আপনার পছন্দের পণ্য';

include PUBLIC_PATH . '/includes/head.php';
include PUBLIC_PATH . '/includes/navbar.php';
?>

<main class="py-4">
    <div class="container">
        <nav aria-label="breadcrumb" class="mb-4">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?= url('public/') ?>">হোম</a></li>
                <li class="breadcrumb-item active">উইশলিস্ট</li>
            </ol>
        </nav>
        
        <h2 class="mb-4"><i class="bi bi-heart me-2"></i>উইশলিস্ট</h2>
        
        <?php if (empty($wishlistItems)): ?>
        <div class="text-center py-5 bg-white rounded shadow-sm">
            <i class="bi bi-heart display-1 text-muted"></i>
            <h4 class="mt-3">আপনার উইশলিস্ট খালি</h4>
            <p class="text-muted">পছন্দের পণ্যগুলো উইশলিস্টে যোগ করুন!</p>
            <a href="<?= url('public/?page=products') ?>" class="btn btn-primary">
                <i class="bi bi-bag me-2"></i>শপ করুন
            </a>
        </div>
        <?php else: ?>
        
        <div class="row g-4">
            <?php foreach ($wishlistItems as $product): ?>
            <div class="col-6 col-md-4 col-lg-3">
                <?php include PUBLIC_PATH . '/includes/product-card.php'; ?>
            </div>
            <?php endforeach; ?>
        </div>
        
        <?php endif; ?>
    </div>
</main>

<?php include PUBLIC_PATH . '/includes/footer.php'; ?>
