<?php
/**
 * Direct Registration Test - Shows actual PHP errors
 */
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Simulate POST request
$_SERVER['REQUEST_METHOD'] = 'POST';
$_POST['full_name'] = 'Test User';
$_POST['email'] = 'test' . time() . '@test.com';
$_POST['phone'] = '01712' . rand(100000, 999999);
$_POST['password'] = 'Test@123';
$_POST['password_confirmation'] = 'Test@123';

echo "<h2>Direct Registration Test</h2>";
echo "<pre>Testing with:\n";
print_r($_POST);
echo "</pre>";

// Now include the registration handler
define('BASE_PATH', __DIR__);
require_once BASE_PATH . '/app/config/config.php';

// Start session and generate CSRF
session_name(SESSION_NAME);
session_start();
$token = CSRF::generateToken();
$_POST['csrf_token'] = $token;

echo "<p>CSRF Token: " . substr($token, 0, 20) . "...</p>";

// Test each step
echo "<h3>Step 1: Validation</h3>";
try {
    $validator = Validator::make($_POST);
    $validator->required('full_name', 'পুরো নাম')
              ->minLength('full_name', 3, 'নাম')
              ->required('email', 'ইমেইল')
              ->email('email')
              ->required('phone', 'মোবাইল নম্বর')
              ->phone('phone')
              ->required('password', 'পাসওয়ার্ড')
              ->minLength('password', PASSWORD_MIN_LENGTH, 'পাসওয়ার্ড')
              ->confirmed('password');
    
    if ($validator->fails()) {
        echo "<p style='color:red'>Validation failed:</p>";
        print_r($validator->errors());
    } else {
        echo "<p style='color:green'>✅ Validation passed</p>";
    }
} catch (Exception $e) {
    echo "<p style='color:red'>❌ Validation error: " . $e->getMessage() . "</p>";
    exit;
}

echo "<h3>Step 2: Check duplicates</h3>";
try {
    $email = sanitize($_POST['email']);
    $phone = sanitize($_POST['phone']);
    
    $emailExists = Database::fetchColumn("SELECT COUNT(*) FROM users WHERE email = ?", [$email]);
    $phoneExists = Database::fetchColumn("SELECT COUNT(*) FROM users WHERE phone = ?", [$phone]);
    
    echo "<p>Email exists: " . ($emailExists ? 'Yes' : 'No') . "</p>";
    echo "<p>Phone exists: " . ($phoneExists ? 'Yes' : 'No') . "</p>";
    echo "<p style='color:green'>✅ Duplicate check passed</p>";
} catch (Exception $e) {
    echo "<p style='color:red'>❌ Database error: " . $e->getMessage() . "</p>";
    exit;
}

echo "<h3>Step 3: Insert user</h3>";
try {
    $passwordHash = password_hash($_POST['password'], PASSWORD_DEFAULT);
    
    $userId = Database::insert(
        "INSERT INTO users (full_name, email, phone, password_hash, created_at) VALUES (?, ?, ?, ?, NOW())",
        [$_POST['full_name'], $email, $phone, $passwordHash]
    );
    
    echo "<p style='color:green'>✅ User created with ID: $userId</p>";
    
    // Cleanup
    Database::execute("DELETE FROM users WHERE id = ?", [$userId]);
    echo "<p style='color:green'>✅ Test user deleted</p>";
    
} catch (PDOException $e) {
    echo "<p style='color:red'>❌ PDO Error: " . $e->getMessage() . "</p>";
    echo "<p>Code: " . $e->getCode() . "</p>";
} catch (Exception $e) {
    echo "<p style='color:red'>❌ Error: " . $e->getMessage() . "</p>";
}

echo "<hr>";
echo "<p style='color:green'><strong>If all steps passed, registration should work!</strong></p>";
echo "<p><a href='public/?page=register'>Go to Registration →</a></p>";
